/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.google.common.collect.Sets;
import com.lothrazar.cyclic.api.IHarvesterOverride;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.item.scythe.ScytheType;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class HarvestUtil {
    public static final Set<IHarvesterOverride> HARVEST_OVERRIDES = Sets.newIdentityHashSet();

    public static boolean harvestByScytheType(Level world, Player player, BlockPos posCurrent, ScytheType type) {
        boolean doBreak = false;
        BlockState blockState = world.m_8055_(posCurrent);
        if (blockState.m_61138_((Property)DoublePlantBlock.f_52858_) && ((DoubleBlockHalf)blockState.m_61143_((Property)DoublePlantBlock.f_52858_)).equals((Object)DoubleBlockHalf.LOWER)) {
            return false;
        }
        switch (type) {
            case LEAVES: {
                doBreak = blockState.m_204336_(BlockTags.f_13035_);
                break;
            }
            case BRUSH: {
                doBreak = blockState.m_204336_(DataTags.PLANTS);
                break;
            }
            case FORAGE: {
                boolean bl = doBreak = blockState.m_204336_(BlockTags.f_13041_) || blockState.m_204336_(BlockTags.f_13064_) || blockState.m_204336_(BlockTags.f_13052_) || blockState.m_204336_(DataTags.MUSHROOMS) || blockState.m_204336_(DataTags.VINES) || blockState.m_204336_(DataTags.CACTUS) || blockState.m_204336_(DataTags.CROP_BLOCKS);
            }
        }
        if (doBreak) {
            if (blockState.m_204336_(DataTags.CROP_BLOCKS)) {
                world.m_46953_(posCurrent, false, (Entity)player);
                ItemStackUtil.drop(world, posCurrent, blockState.m_60734_());
            } else {
                if (type == ScytheType.BRUSH && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player) > 0) {
                    ItemStackUtil.drop(world, posCurrent, blockState.m_60734_());
                } else {
                    blockState.m_60734_().m_6240_(world, player, posCurrent, blockState, world.m_7702_(posCurrent), player.m_21205_());
                }
                world.m_46953_(posCurrent, false, (Entity)player);
            }
            return true;
        }
        return false;
    }

    public static void harvestShape(Level world, BlockPos pos, int radius) {
        List<BlockPos> shape = ShapeUtil.squareHorizontalFull(pos, radius);
        for (BlockPos p : shape) {
            HarvestUtil.tryHarvestSingle(world, p);
        }
    }

    private static boolean simpleBreakDrop(BlockState blockState) {
        boolean breakit = blockState.m_204336_(DataTags.VINES) || blockState.m_204336_(DataTags.CROP_BLOCKS);
        return breakit;
    }

    public static boolean tryHarvestSingle(Level world, BlockPos posCurrent) {
        BlockState newState;
        boolean updated;
        CropBlock crop;
        Object defaultSeedDrop;
        int maxAge;
        BlockState blockState = world.m_8055_(posCurrent);
        IHarvesterOverride applicable = null;
        for (IHarvesterOverride override : HARVEST_OVERRIDES) {
            if (!override.appliesTo(blockState, world, posCurrent)) continue;
            applicable = override;
            break;
        }
        if (applicable != null) {
            return applicable.attemptHarvest(blockState, world, posCurrent, stack -> ItemStackUtil.drop(world, posCurrent, blockState.m_60734_()));
        }
        if (HarvestUtil.simpleBreakDrop(blockState)) {
            ItemStackUtil.drop(world, posCurrent, blockState.m_60734_());
            world.m_46961_(posCurrent, false);
            return true;
        }
        if (world.m_8055_(posCurrent).m_60734_() instanceof StemBlock) {
            return false;
        }
        IntegerProperty propInt = HarvestUtil.getAgeProp(blockState);
        if (propInt == null || !(world instanceof ServerLevel)) {
            return false;
        }
        int currentAge = (Integer)blockState.m_61143_((Property)propInt);
        int minAge = (Integer)Collections.min(propInt.m_6908_());
        if (minAge == (maxAge = ((Integer)Collections.max(propInt.m_6908_())).intValue()) || currentAge < maxAge) {
            return false;
        }
        Item seed = null;
        if (blockState.m_60734_() instanceof CropBlock && !(defaultSeedDrop = (crop = (CropBlock)blockState.m_60734_()).m_7397_((BlockGetter)world, posCurrent, blockState)).m_41619_()) {
            seed = defaultSeedDrop.m_41720_();
        }
        List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)posCurrent, null);
        for (ItemStack dropStack : drops) {
            if (seed != null && dropStack.m_41720_() == seed) {
                dropStack.m_41774_(1);
                seed = null;
            }
            LevelWorldUtil.dropItemStackInWorld(world, posCurrent, dropStack);
        }
        if (world instanceof ServerLevel) {
            boolean isPlayer = true;
            blockState.m_222967_((ServerLevel)world, posCurrent, ItemStack.f_41583_, isPlayer);
        }
        return (updated = world.m_46597_(posCurrent, newState = (BlockState)blockState.m_61124_((Property)propInt, (Comparable)Integer.valueOf(minAge)))) || drops.size() > 0;
    }

    public static IntegerProperty getAgeProp(BlockState blockState) {
        if (blockState.m_60734_() instanceof CropBlock) {
            CropBlock crops = (CropBlock)blockState.m_60734_();
            return crops.m_7959_();
        }
        String age = CropBlock.f_52244_.m_61708_();
        ResourceLocation bid = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
        if ("resynth".equalsIgnoreCase(bid.m_135827_())) {
            age = "growth_stage";
        }
        for (Property p : blockState.m_61147_()) {
            if (p == null || p.m_61708_() == null || !(p instanceof IntegerProperty) || !p.m_61708_().equalsIgnoreCase(age)) continue;
            return (IntegerProperty)p;
        }
        return null;
    }
}

