/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.random;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.random.PacketRandomize;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.EntityUtil;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RandomizerItem
extends ItemBaseCyclic {
    private static final int COOLDOWN = 15;

    public RandomizerItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(4096));
    }

    public static ItemStack getIfHeld(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof RandomizerItem) {
            return heldItem;
        }
        heldItem = player.m_21206_();
        if (heldItem.m_41720_() instanceof RandomizerItem) {
            return heldItem;
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return super.m_6225_(context);
        }
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (player.f_19853_.f_46443_) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketRandomize(pos, side, context.m_43724_()));
        }
        EntityUtil.setCooldownItem(player, this, 15);
        return super.m_6225_(context);
    }

    public static List<BlockPos> getPlaces(BlockPos pos, Direction side) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_();
        int yMin = pos.m_123342_();
        int zMin = pos.m_123343_();
        int xMax = pos.m_123341_();
        int yMax = pos.m_123342_();
        int zMax = pos.m_123343_();
        boolean isVertical = side == Direction.UP || side == Direction.DOWN;
        int offsetRadius = 0;
        offsetRadius = 2;
        if (offsetRadius > 0) {
            if (isVertical) {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                zMin -= offsetRadius;
                zMax += offsetRadius;
            } else if (side == Direction.EAST || side == Direction.WEST) {
                zMin -= offsetRadius;
                zMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            } else {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            }
            places = LevelWorldUtil.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        return places;
    }

    public static boolean canMove(BlockState stateHere, Level world, BlockPos p) {
        if (stateHere.m_60800_((BlockGetter)world, p) < 0.0f) {
            return false;
        }
        return world.m_7702_(p) == null && !world.m_46859_(p) && !stateHere.m_60767_().m_76332_();
    }
}

