/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.magicnet;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import com.lothrazar.cyclic.util.StringParseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityMagicNetEmpty
extends ThrowableItemProjectile {
    public static final String NBT_ENTITYID = "cyclic:magicnet_id";
    public static final int PARTICLE_CAPTURE_COUNT = 8;

    public EntityMagicNetEmpty(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public EntityMagicNetEmpty(Level worldIn, LivingEntity livingEntityIn) {
        super((EntityType)EntityRegistry.MAGIC_NET.get(), livingEntityIn, worldIn);
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.MAGIC_NET.get();
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        SimpleParticleType particleType = null;
        double targetHeightOffset = 0.0;
        if (type == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTrace = (EntityHitResult)result;
            Entity target = entityRayTrace.m_82443_();
            if (target instanceof Player || !target.m_6084_()) {
                return;
            }
            if (target.m_146895_() instanceof Player) {
                return;
            }
            if (target instanceof LivingEntity) {
                ((LivingEntity)target).m_5796_();
            }
            CompoundTag compound = new CompoundTag();
            target.m_20223_(compound);
            if (target.m_6095_() == EntityType.f_20470_ || target.m_6095_() == EntityType.f_20471_ || target.m_6095_() == EntityType.f_20472_ || target.m_6095_() == EntityType.f_20473_) {
                return;
            }
            String id = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
            if (StringParseUtil.isInList(ConfigRegistry.getMagicNetList(), EntityType.m_20613_((EntityType)target.m_6095_()))) {
                ModCyclic.LOGGER.info("ignored by: CONFIG LIST" + id);
                return;
            }
            compound.m_128359_(NBT_ENTITYID, id);
            ItemStack drop = new ItemStack((ItemLike)ItemRegistry.MOB_CONTAINER.get());
            drop.m_41751_(compound);
            targetHeightOffset = target.m_20206_() / 2.0f;
            particleType = ParticleTypes.f_123760_;
            ItemStackUtil.drop(this.f_19853_, this.m_20183_(), drop);
            SoundUtil.playSound(target, (SoundEvent)SoundRegistry.MONSTER_BALL_CAPTURE.get());
            target.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (type == HitResult.Type.BLOCK) {
            BlockPos pos = this.m_20183_();
            targetHeightOffset = 0.0;
            particleType = ParticleTypes.f_123759_;
            ItemStackUtil.drop(this.f_19853_, pos, new ItemStack((ItemLike)ItemRegistry.MAGIC_NET.get()));
        }
        if (particleType != null) {
            Vec3 hitVec = result.m_82450_();
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)particleType, hitVec.m_7096_(), hitVec.m_7098_() + targetHeightOffset, hitVec.m_7094_(), this.f_19796_.m_188583_() * 0.1, 0.0, this.f_19796_.m_188583_() * 0.1);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

