/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.filesystem.CyclicFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDataEvents {
    public static Map<UUID, CyclicFile> DATA_QUEUE = new HashMap<UUID, CyclicFile>();
    public static final String FILE_EXT = ".dat";

    public static CyclicFile getOrCreate(Player player) {
        UUID id = player.m_20148_();
        if (!DATA_QUEUE.containsKey(id)) {
            DATA_QUEUE.put(id, new CyclicFile(player.m_20148_()));
        }
        return DATA_QUEUE.get(id);
    }

    @SubscribeEvent
    public void onSaveFile(PlayerEvent.SaveToFile event) {
        Player player = event.getEntity();
        if (DATA_QUEUE.containsKey(player.m_20148_())) {
            CyclicFile dataToSave = DATA_QUEUE.get(player.m_20148_());
            CompoundTag data = dataToSave.write();
            try {
                File mctomb = new File(event.getPlayerDirectory(), this.getPlayerFile(player));
                FileOutputStream fileoutputstream = new FileOutputStream(mctomb);
                NbtIo.m_128947_((CompoundTag)data, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (IOException e) {
                ModCyclic.LOGGER.error("IO cyclic file error", e);
            }
        }
    }

    private String getPlayerFile(Player player) {
        return player.m_20148_() + "_cyclic.dat";
    }

    @SubscribeEvent
    public void onLoadFile(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        File mctomb = new File(event.getPlayerDirectory(), this.getPlayerFile(player));
        if (mctomb.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(mctomb);
                CompoundTag data = NbtIo.m_128939_((InputStream)fileinputstream);
                fileinputstream.close();
                CyclicFile dataLoaded = new CyclicFile(player.m_20148_());
                dataLoaded.read(data);
                DATA_QUEUE.put(player.m_20148_(), dataLoaded);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("IO error", e);
            }
        }
    }
}

