/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.capabilities;

import com.lothrazar.cyclic.capabilities.chunk.ChunkDataStorage;
import com.lothrazar.cyclic.capabilities.player.PlayerCapProvider;
import com.lothrazar.cyclic.capabilities.player.PlayerCapabilityStorage;
import com.lothrazar.cyclic.net.PacketSyncManaToClient;
import com.lothrazar.cyclic.registry.PacketRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.network.PacketDistributor;

public class CyclicWorldSavedData
extends SavedData {
    private final Map<ChunkPos, ChunkDataStorage> chunkPosData = new HashMap<ChunkPos, ChunkDataStorage>();
    private final Random random = new Random();
    private int syncToClientCounter = 0;

    public CyclicWorldSavedData() {
    }

    public CyclicWorldSavedData(CompoundTag tag) {
        ListTag list = tag.m_128437_("mana", 10);
        for (Tag t : list) {
            CompoundTag manaTag = (CompoundTag)t;
            ChunkDataStorage mana = new ChunkDataStorage(manaTag);
            ChunkPos chunkPos = new ChunkPos(manaTag.m_128451_("x"), manaTag.m_128451_("z"));
            this.chunkPosData.put(chunkPos, mana);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.chunkPosData.forEach((chunkPos, mana) -> {
            CompoundTag manaTag = new CompoundTag();
            manaTag.m_128405_("x", chunkPos.f_45578_);
            manaTag.m_128405_("z", chunkPos.f_45579_);
            mana.save(manaTag);
            list.add((Object)manaTag);
        });
        tag.m_128365_("mana", (Tag)list);
        return tag;
    }

    @Nonnull
    public static CyclicWorldSavedData get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (CyclicWorldSavedData)storage.m_164861_(CyclicWorldSavedData::new, CyclicWorldSavedData::new, "data");
    }

    private ChunkDataStorage getDataForPos(BlockPos pos) {
        return this.getDataForChunk(new ChunkPos(pos));
    }

    private ChunkDataStorage getDataForChunk(ChunkPos chunkPos) {
        return this.chunkPosData.computeIfAbsent(chunkPos, cp -> new ChunkDataStorage(this.random.nextInt(4444, 7777)));
    }

    public void onWorldTick(Level level) {
        --this.syncToClientCounter;
        if (this.syncToClientCounter <= 0) {
            this.syncToClientCounter = 10;
            level.m_6907_().forEach(p -> {
                if (p instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)p;
                    PlayerCapabilityStorage playerData = (PlayerCapabilityStorage)serverPlayer.getCapability(PlayerCapProvider.CYCLIC_PLAYER).orElse(null);
                    ChunkDataStorage chunkData = this.getDataForPos(serverPlayer.m_20183_());
                    PacketRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketSyncManaToClient(playerData, chunkData));
                }
            });
        }
    }
}

