/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.FluidHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileTank
extends TileBlockEntityCyclic {
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    public FluidTankBase tank = new FluidTankBase(this, 64000, p -> true);
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.TANK.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileTank e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileTank e) {
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        CompoundTag fluid = tag.m_128469_("fluid");
        this.tank.readFromNBT(fluid);
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
        this.updateComparatorOutputLevel();
    }

    public void tick() {
        BlockEntity below = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (below != null && below instanceof TileTank) {
            FluidHelpers.tryFillPositionFromTank(this.f_58857_, this.f_58858_.m_7495_(), Direction.UP, (IFluidHandler)this.tank, 50);
            this.updateComparatorOutputLevel();
            this.updateComparatorOutputLevelAt(this.f_58858_.m_7495_());
        }
    }
}

