/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfluid;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.generatorfluid.TileGeneratorFluid;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.cyclic.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGeneratorFluid
implements Recipe<TileGeneratorFluid> {
    private final ResourceLocation id;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    public final FluidTagIngredient fluidIng;
    private final EnergyIngredient energy;

    public RecipeGeneratorFluid(ResourceLocation id, FluidTagIngredient in, EnergyIngredient energy) {
        this.id = id;
        this.fluidIng = in;
        this.energy = energy;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack assemble(TileGeneratorFluid inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public FluidStack getRecipeFluid() {
        return this.fluidIng.getFluidStack();
    }

    public boolean matches(TileGeneratorFluid inv, Level worldIn) {
        try {
            TileGeneratorFluid tile = inv;
            return RecipeUtil.matchFluid(tile.getFluid(), this.fluidIng);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CyclicRecipeType.GENERATOR_FLUID.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CyclicRecipeType.GENERATOR_FLUID_S.get();
    }

    public int getTicks() {
        return this.energy.getTicks();
    }

    public int getRfpertick() {
        return this.energy.getRfPertick();
    }

    public int getRfTotal() {
        return this.getRfpertick() * this.getTicks();
    }

    public static class SerializeGenerateFluid
    implements RecipeSerializer<RecipeGeneratorFluid> {
        public RecipeGeneratorFluid fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeGeneratorFluid r = null;
            try {
                FluidTagIngredient fs = RecipeUtil.parseFluid(json, "fuel");
                r = new RecipeGeneratorFluid(recipeId, fs, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeGeneratorFluid fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new RecipeGeneratorFluid(recipeId, FluidTagIngredient.readFromPacket(buffer), new EnergyIngredient(buffer.readInt(), buffer.readInt()));
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeGeneratorFluid recipe) {
            recipe.fluidIng.writeToPacket(buffer);
            buffer.writeInt(recipe.energy.getRfPertick());
            buffer.writeInt(recipe.energy.getTicks());
        }
    }
}

