/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.renderer.ExperienceObeliskItemRenderer;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ExperienceObeliskItem
extends BlockItem
implements IAnimatable {
    private final AnimationFactory manager = GeckoLibUtil.createFactory((IAnimatable)this);

    public ExperienceObeliskItem(Block block, Item.Properties p) {
        super(block, p);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        controller.setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new ExperienceObeliskItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int amount = stack.m_41784_().m_128469_("BlockEntityTag").m_128451_("Amount");
        int levels = ExperienceUtils.xpToLevels(amount / 20);
        if (stack.m_41782_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.experienceobelisk.experience_obelisk.item_levels", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(levels)).m_130940_(ChatFormatting.GREEN)}));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.experienceobelisk.experience_obelisk.item_points", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(amount / 20)).m_130940_(ChatFormatting.GREEN)}));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

