/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private final Set<ResourceLocation> registeredTextures = new HashSet<ResourceLocation>();
    private final Object2BooleanMap<ResourceLocation> wrappedModels = new Object2BooleanLinkedOpenHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        HashSet sprites = new HashSet((Collection)ObfuscationReflectionHelper.getPrivateValue(TextureStitchEvent.Pre.class, (Object)event, (String)"sprites"));
        for (ResourceLocation rel : sprites) {
            try {
                rel = new ResourceLocation(rel.m_135827_(), "textures/" + rel.m_135815_() + ".png");
                Optional<IMetadataSectionCTM> metadata = ResourceUtil.getMetadata(rel);
                Optional<String> proxy = metadata.map(IMetadataSectionCTM::getProxy);
                if (proxy.isPresent()) {
                    ResourceLocation proxysprite = new ResourceLocation(proxy.get());
                    Optional<IMetadataSectionCTM> proxymeta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(proxysprite));
                    event.addSprite(proxysprite);
                    proxymeta.ifPresent(m -> {
                        for (ResourceLocation r : m.getAdditionalTextures()) {
                            if (!this.registeredTextures.add(r)) continue;
                            event.addSprite(r);
                        }
                    });
                }
                metadata.map(IMetadataSectionCTM::getAdditionalTextures).ifPresent(textures -> {
                    for (ResourceLocation r : textures) {
                        if (!this.registeredTextures.add(r)) continue;
                        event.addSprite(r);
                    }
                });
            }
            catch (FileNotFoundException metadata) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelEvent.BakingCompleted event) {
        Map stateModels = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelBakery(), (String)"f_119212_");
        for (ResourceLocation rl : event.getModels().keySet()) {
            BakedModel baked;
            UnbakedModel rootModel = (UnbakedModel)stateModels.get(rl);
            if (rootModel == null || (baked = (BakedModel)event.getModels().get(rl)) instanceof AbstractCTMBakedModel || baked.m_7521_()) continue;
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = this.wrappedModels.getOrDefault((Object)rl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : event.getModelBakery().m_119341_(dep);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    HashSet textures = Sets.newHashSet((Iterable)model.m_5500_(arg_0 -> ((ModelBakery)event.getModelBakery()).m_119341_(arg_0), (Set)Sets.newHashSet()));
                    HashSet newDependencies = Sets.newHashSet((Iterable)model.m_7970_());
                    for (Material tex : textures) {
                        IMetadataSectionCTM meta = null;
                        try {
                            meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex.m_119203_())).orElse(null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (meta == null) continue;
                        shouldWrap = true;
                    }
                    for (ResourceLocation newDep : newDependencies) {
                        if (!seenModels.add(newDep)) continue;
                        dependencies.push(newDep);
                    }
                }
                catch (Exception e) {
                    CTM.logger.error((Message)new ParameterizedMessage("Error loading model dependency {} for model {}. Skipping...", (Object)dep, (Object)rl), (Throwable)e);
                }
            }
            this.wrappedModels.put((Object)rl, shouldWrap);
            if (!shouldWrap) continue;
            try {
                event.getModels().put(rl, this.wrap(rl, rootModel, baked, event.getModelBakery()));
                dependencies.clear();
            }
            catch (IOException e) {
                CTM.logger.error("Could not wrap model " + rl + ". Aborting...", (Throwable)e);
            }
        }
    }

    @Nonnull
    private BakedModel wrap(ResourceLocation loc, UnbakedModel model, BakedModel object, ModelBakery loader) throws IOException {
        ModelCTM modelchisel = new ModelCTM(model);
        modelchisel.initializeTextures(loader, m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(m.m_119203_()));
        return new ModelBakedCTM(modelchisel, object, null);
    }

    public void invalidateCaches() {
        this.registeredTextures.clear();
        this.wrappedModels.clear();
    }
}

