/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextGrid;
import team.chisel.ctm.client.texture.ctx.TextureContextPosition;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypeMap;
import team.chisel.ctm.client.util.Quad;
import team.chisel.ctm.client.util.Submap;

public class TextureMap
extends AbstractTexture<TextureTypeMap> {
    private final int xSize;
    private final int ySize;
    private final int xOffset;
    private final int yOffset;
    private final MapType map;

    public TextureMap(TextureTypeMap type, TextureInfo info, MapType map) {
        super(type, info);
        this.map = map;
        if (info.getInfo().isPresent()) {
            JsonObject object = info.getInfo().get();
            if (object.has("width") && object.has("height")) {
                Preconditions.checkArgument((object.get("width").isJsonPrimitive() && object.get("width").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"width must be a number!");
                Preconditions.checkArgument((object.get("height").isJsonPrimitive() && object.get("height").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"height must be a number!");
                this.xSize = object.get("width").getAsInt();
                this.ySize = object.get("height").getAsInt();
            } else if (object.has("size")) {
                Preconditions.checkArgument((object.get("size").isJsonPrimitive() && object.get("size").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"size must be a number!");
                this.xSize = object.get("size").getAsInt();
                this.ySize = object.get("size").getAsInt();
            } else {
                this.ySize = 2;
                this.xSize = 2;
            }
            if (object.has("x_offset")) {
                Preconditions.checkArgument((object.get("x_offset").isJsonPrimitive() && object.get("x_offset").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"x_offset must be a number!");
                this.xOffset = object.get("x_offset").getAsInt();
            } else {
                this.xOffset = 0;
            }
            if (object.has("y_offset")) {
                Preconditions.checkArgument((object.get("y_offset").isJsonPrimitive() && object.get("y_offset").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"y_offset must be a number!");
                this.yOffset = object.get("y_offset").getAsInt();
            } else {
                this.yOffset = 0;
            }
        } else {
            this.yOffset = 0;
            this.xOffset = 0;
            this.ySize = 2;
            this.xSize = 2;
        }
        Preconditions.checkArgument((this.xSize > 0 && this.ySize > 0 ? 1 : 0) != 0, (Object)"Cannot have a dimension of 0!");
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, ITextureContext context, int quadGoal) {
        return this.map.transformQuad(this, quad, context, quadGoal);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MapType {
        RANDOM{

            @Override
            protected List<BakedQuad> transformQuad(TextureMap tex, BakedQuad quad, @Nullable ITextureContext context, int quadGoal) {
                TextureContextGrid.Point2i textureCoords = context == null ? new TextureContextGrid.Point2i(1, 1) : ((TextureContextGrid)context).getTextureCoords(quad.m_111306_());
                float intervalX = 16.0f / (float)tex.getXSize();
                float intervalY = 16.0f / (float)tex.getYSize();
                float maxU = (float)textureCoords.getX() * intervalX;
                float maxV = (float)textureCoords.getY() * intervalY;
                Submap uvs = new Submap(intervalX, intervalY, maxU - intervalX, maxV - intervalY);
                Quad q = tex.makeQuad(quad, context).setFullbright(tex.fullbright);
                if (quadGoal != 4) {
                    return Collections.singletonList(q.transformUVs(tex.sprites[0], uvs).setFullbright(tex.fullbright).rebake());
                }
                Quad[] quads = q.subdivide(4);
                for (int i = 0; i < quads.length; ++i) {
                    if (quads[i] == null) continue;
                    quads[i] = quads[i].transformUVs(tex.sprites[0], uvs);
                }
                return Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).toList();
            }

            @Override
            public ITextureContext getContext(@Nonnull BlockPos pos, @Nonnull TextureMap tex) {
                return new TextureContextGrid.Random(pos, tex, true);
            }
        }
        ,
        PATTERNED{

            @Override
            protected List<BakedQuad> transformQuad(TextureMap tex, BakedQuad quad, @Nullable ITextureContext context, int quadGoal) {
                TextureContextGrid.Point2i textureCoords = context == null ? new TextureContextGrid.Point2i(0, 0) : ((TextureContextGrid)context).getTextureCoords(quad.m_111306_());
                float intervalU = 16.0f / (float)tex.xSize;
                float intervalV = 16.0f / (float)tex.ySize;
                float minU = intervalU * (float)textureCoords.getX();
                float minV = intervalV * (float)textureCoords.getY();
                Submap submap = new Submap(intervalU, intervalV, minU, minV);
                Quad q = tex.makeQuad(quad, context).setFullbright(tex.fullbright);
                if (quadGoal != 4) {
                    return Collections.singletonList(q.transformUVs(tex.sprites[0], submap).rebake());
                }
                Quad[] quads = q.subdivide(4);
                for (int i = 0; i < quads.length; ++i) {
                    if (quads[i] == null) continue;
                    quads[i] = quads[i].transformUVs(tex.sprites[0], submap);
                }
                return Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).toList();
            }

            @Override
            public ITextureContext getContext(@Nonnull BlockPos pos, @Nonnull TextureMap tex) {
                return new TextureContextGrid.Patterned(pos, tex, true);
            }
        };


        protected abstract List<BakedQuad> transformQuad(TextureMap var1, BakedQuad var2, @Nullable ITextureContext var3, int var4);

        @Nonnull
        public ITextureContext getContext(@Nonnull BlockPos pos, @Nonnull TextureMap tex) {
            return new TextureContextPosition(pos);
        }
    }
}

