/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import org.lwjgl.opengl.GL32;

public class ShapeListImpl
extends ObjectSelectionList<Entry>
implements IShapeList {
    private Runnable update;

    public ShapeListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, Runnable update) {
        super(minecraft, right - left, bottom - top, top, bottom, slotHeight);
        this.f_93393_ = left;
        this.f_93392_ = right;
        this.m_93488_(false);
        this.m_93496_(false);
        this.update = update;
        for (int shapeSetId = 0; shapeSetId < BuildGuide.stateManager.getState().shapeSets.size(); ++shapeSetId) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeSetId));
            if (shapeSetId != BuildGuide.stateManager.getState().getShapeSetIndex()) continue;
            this.setSelected((Entry)this.m_6702_().get(this.m_6702_().size() - 1));
        }
    }

    @Override
    public void setYPosition(int y) {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void addEntry(int shapeSetId) {
        this.m_7085_((AbstractSelectionList.Entry)new Entry(shapeSetId));
        this.setSelected((Entry)this.m_6702_().get(shapeSetId));
    }

    public boolean removeEntry(Entry entry) {
        for (Entry e : this.m_6702_()) {
            if (e.getShapeSetId() <= entry.getShapeSetId()) continue;
            e.setShapeSetId(e.getShapeSetId() - 1);
        }
        if (this.m_6702_().size() > entry.getShapeSetId() + 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeSetId() + 1));
        } else if (this.m_6702_().size() > 1) {
            this.setSelected((Entry)this.m_6702_().get(entry.getShapeSetId() - 1));
        }
        return super.m_93502_((AbstractSelectionList.Entry)entry);
    }

    @Override
    public boolean removeEntry(IShapeList.IEntry entry) {
        return this.removeEntry((Entry)entry);
    }

    public void setSelected(@Nullable Entry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            BuildGuide.stateManager.getState().setShapeSetIndex(entry.getShapeSetId());
        }
        this.update.run();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        boolean hasBlend = GL32.glIsEnabled((int)3042);
        if (!hasBlend) {
            RenderSystem.m_69478_();
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_5752_();
        tessellator.m_85914_();
        if (!hasBlend) {
            RenderSystem.m_69461_();
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    protected void m_93451_(PoseStack poseStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        boolean hasDepthTest = GL32.glIsEnabled((int)2929);
        boolean hasDepthMask = GL32.glGetBoolean((int)2930);
        int depthFunc = GL32.glGetInteger((int)2932);
        boolean hasBlend = GL32.glIsEnabled((int)3042);
        if (!hasDepthTest) {
            RenderSystem.m_69482_();
        }
        if (!hasDepthMask) {
            RenderSystem.m_69458_((boolean)true);
        }
        if (depthFunc != 515) {
            RenderSystem.m_69456_((int)515);
        }
        if (!hasBlend) {
            RenderSystem.m_69478_();
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ - this.f_93387_ - 4), 0.1).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.1).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.1).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ - this.f_93387_ - 4), 0.1).m_5752_();
        tessellator.m_85914_();
        super.m_93451_(poseStack, x, y, mouseX, mouseY, partialTicks);
        if (!hasBlend) {
            RenderSystem.m_69461_();
        }
        if (depthFunc != 515) {
            RenderSystem.m_69456_((int)depthFunc);
        }
        if (!hasDepthMask) {
            RenderSystem.m_69458_((boolean)false);
        }
        if (!hasDepthTest) {
            RenderSystem.m_69465_();
        }
    }

    public int m_5759_() {
        return this.f_93388_ - 12;
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements IShapeList.IEntry {
        private int shapeSetId;

        public Entry(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        public void m_6311_(PoseStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Minecraft.m_91087_().f_91062_.m_92750_(poseStack, BuildGuide.screenHandler.getFormattedShapeName(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId)), (float)(x + 5), (float)(y + 4), BuildGuide.screenHandler.getShapeProgressColour(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId).getShape()));
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ShapeListImpl.this.setSelected(this);
            return false;
        }

        @Override
        public void setShapeSetId(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        @Override
        public int getShapeSetId() {
            return this.shapeSetId;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"");
        }
    }
}

