/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeRegistry;

public class ShapeSet {
    private static final String PERSISTENCE_INDEX = "index";
    private static final String PERSISTENCE_ORIGIN = "origin";
    private static final String PERSISTENCE_VISIBLE = "visible";
    private static final String PERSISTENCE_SHAPECOLOUR = "shapeColour";
    private static final String PERSISTENCE_ORIGINCOLOUR = "originColour";
    public Shape[] shapes = new Shape[ShapeRegistry.getNumberOfShapes()];
    private int index;
    public Origin origin;
    public boolean visible = true;
    public float colourShapeR = 1.0f;
    public float colourShapeG = 1.0f;
    public float colourShapeB = 1.0f;
    public float colourShapeA = 0.5f;
    public float colourOriginR = 1.0f;
    public float colourOriginG = 0.0f;
    public float colourOriginB = 0.0f;
    public float colourOriginA = 0.5f;

    public ShapeSet(int startIndex) {
        this.index = startIndex;
        this.shapes[this.index] = this.initialiseShape(ShapeRegistry.getClassIdentifier(this.index));
    }

    private Shape initialiseShape(String shapeId) {
        Shape newShape = ShapeRegistry.getNewInstance(shapeId);
        newShape.shapeSet = this;
        return newShape;
    }

    public void resetOrigin() {
        this.origin = BuildGuide.shapeHandler.getPlayerPosition();
    }

    public void updateShape() {
        if (this.shapes[this.index] != null) {
            this.shapes[this.index].update();
        }
    }

    public void updateAllShapes() {
        for (Shape s : this.shapes) {
            if (s == null) continue;
            s.update();
        }
    }

    public void setOriginX(int x) {
        this.origin.x = x;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOriginY(int y) {
        this.origin.y = y;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOriginZ(int z) {
        this.origin.z = z;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void setOrigin(int x, int y, int z) {
        this.origin.x = x;
        this.origin.y = y;
        this.origin.z = z;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public void shiftOrigin(int dx, int dy, int dz) {
        this.origin.x += dx;
        this.origin.y += dy;
        this.origin.z += dz;
        BaseScreen.shouldUpdatePersistence = true;
    }

    public boolean isShapeAvailable() {
        return this.isShapeAvailable(this.index);
    }

    public boolean isShapeAvailable(int index) {
        return this.shapes[index] != null;
    }

    public Shape getShape() {
        if (this.shapes[this.index] == null) {
            this.shapes[this.index] = this.initialiseShape(ShapeRegistry.getClassIdentifier(this.index));
            this.shapes[this.index].update();
        }
        return this.shapes[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toPersistence() {
        Object persistenceData = "";
        persistenceData = (String)persistenceData + "index=" + this.index + ";";
        persistenceData = (String)persistenceData + "origin=" + this.origin.x + "," + this.origin.y + "," + this.origin.z + ";";
        persistenceData = (String)persistenceData + "visible=" + this.visible + ";";
        persistenceData = (String)persistenceData + "shapeColour=" + this.colourShapeR + "," + this.colourShapeG + "," + this.colourShapeB + "," + this.colourShapeA + ";";
        persistenceData = (String)persistenceData + "originColour=" + this.colourOriginR + "," + this.colourOriginG + "," + this.colourOriginB + "," + this.colourOriginA + ";";
        for (Shape s : this.shapes) {
            if (s == null) continue;
            persistenceData = (String)persistenceData + s.getClass().getName() + "=" + s.toPersistence() + ";";
        }
        return persistenceData;
    }

    public void restorePersistence(String persistenceData) {
        String[] splitData;
        for (String entry : splitData = persistenceData.split(";")) {
            int separatorIndex = entry.indexOf("=");
            if (separatorIndex <= 0) continue;
            String key = entry.substring(0, separatorIndex);
            String value = entry.substring(separatorIndex + 1);
            if (key.equals(PERSISTENCE_INDEX)) {
                this.index = Integer.parseInt(value);
                continue;
            }
            if (key.equals(PERSISTENCE_ORIGIN)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 3) continue;
                this.origin.x = Integer.parseInt(splitEntry[0]);
                this.origin.y = Integer.parseInt(splitEntry[1]);
                this.origin.z = Integer.parseInt(splitEntry[2]);
                continue;
            }
            if (key.equals(PERSISTENCE_VISIBLE)) {
                this.visible = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals(PERSISTENCE_SHAPECOLOUR)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 4) continue;
                this.colourShapeR = Float.parseFloat(splitEntry[0]);
                this.colourShapeG = Float.parseFloat(splitEntry[1]);
                this.colourShapeB = Float.parseFloat(splitEntry[2]);
                this.colourShapeA = Float.parseFloat(splitEntry[3]);
                continue;
            }
            if (key.equals(PERSISTENCE_ORIGINCOLOUR)) {
                String[] splitEntry = value.split(",");
                if (splitEntry.length != 4) continue;
                this.colourOriginR = Float.parseFloat(splitEntry[0]);
                this.colourOriginG = Float.parseFloat(splitEntry[1]);
                this.colourOriginB = Float.parseFloat(splitEntry[2]);
                this.colourOriginA = Float.parseFloat(splitEntry[3]);
                continue;
            }
            int index = ShapeRegistry.getShapeId(key);
            if (index < 0) continue;
            this.shapes[index] = this.initialiseShape(key);
            this.shapes[index].restorePersistence(value);
        }
        this.index = Math.max(0, Math.min(this.shapes.length - 1, this.index));
    }

    public static class Origin {
        public int x;
        public int y;
        public int z;

        public Origin(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

