/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ShapeRegistry {
    private static Map<String, Class<? extends Shape>> shapeRegistry = new HashMap<String, Class<? extends Shape>>();
    private static ArrayList<String> classIdentifiers = new ArrayList();
    private static ArrayList<String> translationKeys = new ArrayList();

    public static void registerShape(Class<? extends Shape> shapeClass) {
        shapeRegistry.put(shapeClass.getName(), shapeClass);
        classIdentifiers.add(shapeClass.getName());
        translationKeys.add(ShapeRegistry.getNewInstance(shapeClass.getName()).getTranslationKey());
    }

    public static Shape getNewInstance(String classIdentifier) {
        try {
            return shapeRegistry.get(classIdentifier).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BuildGuide.logHandler.fatal("Unable to instantiate Shape class '" + classIdentifier + "'");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static int getNumberOfShapes() {
        return classIdentifiers.size();
    }

    public static String getClassIdentifier(Class<? extends Shape> shapeClass) {
        for (String classIdentifier : classIdentifiers) {
            if (shapeRegistry.get(classIdentifier) != shapeClass) continue;
            return classIdentifier;
        }
        return null;
    }

    public static String getClassIdentifier(int index) {
        if (index < ShapeRegistry.getNumberOfShapes()) {
            return classIdentifiers.get(index);
        }
        return null;
    }

    public static String getTranslationKey(int index) {
        if (index < ShapeRegistry.getNumberOfShapes()) {
            return translationKeys.get(index);
        }
        return null;
    }

    public static int getShapeId(Class<? extends Shape> shapeClass) {
        String classIdentifier = ShapeRegistry.getClassIdentifier(shapeClass);
        if (classIdentifier == null) {
            return 0;
        }
        return ShapeRegistry.getShapeId(classIdentifier);
    }

    public static int getShapeId(String classIdentifier) {
        return classIdentifiers.contains(classIdentifier) ? classIdentifiers.indexOf(classIdentifier) : -1;
    }

    public static boolean isClassIdentifierValid(String classIdentifier) {
        return classIdentifiers.contains(classIdentifier);
    }
}

