/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeScreen
extends BaseScreen {
    private AbstractScreenHandler.Translatable titleShapeProperties = new AbstractScreenHandler.Translatable("screen.buildguide.shapeproperties", new Object[0]);
    private AbstractScreenHandler.Translatable titleOrigin = new AbstractScreenHandler.Translatable("screen.buildguide.origin", new Object[0]);
    private AbstractScreenHandler.Translatable titleShape = new AbstractScreenHandler.Translatable("screen.buildguide.shape", new Object[0]);
    private IButton buttonShapePrevious = BuildGuide.widgetHandler.createButton(5, 70, 20, 20, new AbstractScreenHandler.Translatable("<-", new Object[0]), () -> this.updateShape(-1));
    private IButton buttonShapeNext = BuildGuide.widgetHandler.createButton(145, 70, 20, 20, new AbstractScreenHandler.Translatable("->", new Object[0]), () -> this.updateShape(1));
    private IButton buttonOrigin = BuildGuide.widgetHandler.createButton(5, 115, 160, 20, new AbstractScreenHandler.Translatable("screen.buildguide.setorigin", new Object[0]), () -> this.setOrigin());
    private IButton buttonOriginXDecrease = BuildGuide.widgetHandler.createButton(25, 135, 20, 20, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftOrigin(-1, 0, 0));
    private IButton buttonOriginXIncrease = BuildGuide.widgetHandler.createButton(145, 135, 20, 20, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftOrigin(1, 0, 0));
    private IButton buttonOriginYDecrease = BuildGuide.widgetHandler.createButton(25, 155, 20, 20, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftOrigin(0, -1, 0));
    private IButton buttonOriginYIncrease = BuildGuide.widgetHandler.createButton(145, 155, 20, 20, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftOrigin(0, 1, 0));
    private IButton buttonOriginZDecrease = BuildGuide.widgetHandler.createButton(25, 175, 20, 20, new AbstractScreenHandler.Translatable("-", new Object[0]), () -> this.shiftOrigin(0, 0, -1));
    private IButton buttonOriginZIncrease = BuildGuide.widgetHandler.createButton(145, 175, 20, 20, new AbstractScreenHandler.Translatable("+", new Object[0]), () -> this.shiftOrigin(0, 0, 1));
    private ITextField textFieldX = BuildGuide.widgetHandler.createTextField(45, 135, 70, 20, "");
    private ITextField textFieldY = BuildGuide.widgetHandler.createTextField(45, 155, 70, 20, "");
    private ITextField textFieldZ = BuildGuide.widgetHandler.createTextField(45, 175, 70, 20, "");
    private IButton buttonSetX = BuildGuide.widgetHandler.createButton(115, 135, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldX.getTextValue());
            BuildGuide.stateManager.getState().setOriginX(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldX.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetY = BuildGuide.widgetHandler.createButton(115, 155, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldY.getTextValue());
            BuildGuide.stateManager.getState().setOriginY(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldY.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetZ = BuildGuide.widgetHandler.createButton(115, 175, 30, 20, new AbstractScreenHandler.Translatable("screen.buildguide.set", new Object[0]), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldZ.getTextValue());
            BuildGuide.stateManager.getState().setOriginZ(newval);
        }
        catch (NumberFormatException e) {
            this.textFieldZ.setTextColour(0xFF0000);
        }
    });

    @Override
    public void init() {
        super.init();
        if (!BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.buttonShapePrevious.setActive(false);
            this.buttonShapeNext.setActive(false);
            this.buttonOrigin.setActive(false);
            this.buttonOriginXDecrease.setActive(false);
            this.buttonOriginXIncrease.setActive(false);
            this.buttonOriginYDecrease.setActive(false);
            this.buttonOriginYIncrease.setActive(false);
            this.buttonOriginZDecrease.setActive(false);
            this.buttonOriginZIncrease.setActive(false);
            this.buttonSetX.setActive(false);
            this.buttonSetY.setActive(false);
            this.buttonSetZ.setActive(false);
        }
        this.textFieldX.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.x : "-"));
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.y : "-"));
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.z : "-"));
        this.textFieldZ.setTextColour(0xFFFFFF);
        this.addWidget(this.buttonShapePrevious);
        this.addWidget(this.buttonShapeNext);
        this.addWidget(this.buttonOrigin);
        this.addWidget(this.buttonOriginXDecrease);
        this.addWidget(this.textFieldX);
        this.addWidget(this.buttonSetX);
        this.addWidget(this.buttonOriginXIncrease);
        this.addWidget(this.buttonOriginYDecrease);
        this.addWidget(this.textFieldY);
        this.addWidget(this.buttonSetY);
        this.addWidget(this.buttonOriginYIncrease);
        this.addWidget(this.buttonOriginZDecrease);
        this.addWidget(this.textFieldZ);
        this.addWidget(this.buttonSetZ);
        this.addWidget(this.buttonOriginZIncrease);
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            for (Shape shape : BuildGuide.stateManager.getState().getCurrentShapeSet().shapes) {
                if (shape == null) continue;
                shape.onDeselectedInGUI();
                this.addShapeProperties(shape);
            }
            BuildGuide.stateManager.getState().getCurrentShape().onSelectedInGUI();
        }
    }

    @Override
    public void render() {
        super.render();
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleShape), 85, 55, 0xFFFFFF);
        this.drawShadowCentred(BuildGuide.screenHandler.getFormattedShapeName(BuildGuide.stateManager.getState().getCurrentShapeSet()), 85, 75, BuildGuide.screenHandler.getShapeProgressColour(BuildGuide.stateManager.getState().getCurrentShape()));
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleOrigin), 85, 100, 0xFFFFFF);
        this.drawShadowLeft("X", 10, 140, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowLeft("Y", 10, 160, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowLeft("Z", 10, 180, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadowCentred(BuildGuide.screenHandler.TEXT_MODIFIER_UNDERLINE + String.valueOf(this.titleShapeProperties), 285, 55, 0xFFFFFF);
    }

    private void addShapeProperties(Shape shape) {
        for (Property<?> p : shape.properties) {
            this.addProperty(p);
        }
    }

    private void updateShape(int di) {
        BuildGuide.stateManager.getState().getCurrentShape().onDeselectedInGUI();
        BuildGuide.stateManager.getState().shiftShape(di);
        if (!BuildGuide.stateManager.getState().getCurrentShapeSet().isShapeAvailable()) {
            this.addShapeProperties(BuildGuide.stateManager.getState().getCurrentShape());
        }
        BuildGuide.stateManager.getState().getCurrentShape().onSelectedInGUI();
    }

    private void setOrigin() {
        BuildGuide.stateManager.getState().resetOrigin();
        BaseScreen.shouldUpdatePersistence = true;
        this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.x);
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.y);
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.z);
        this.textFieldZ.setTextColour(0xFFFFFF);
    }

    private void shiftOrigin(int dx, int dy, int dz) {
        BuildGuide.stateManager.getState().shiftOrigin(dx, dy, dz);
        if (dx != 0) {
            this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.x);
            this.textFieldX.setTextColour(0xFFFFFF);
        }
        if (dy != 0) {
            this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.y);
            this.textFieldY.setTextColour(0xFFFFFF);
        }
        if (dz != 0) {
            this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShapeSet().origin.z);
            this.textFieldZ.setTextColour(0xFFFFFF);
        }
    }
}

