/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.util.SparkUtil;
import org.zeith.hammerlib.api.energy.EnergyUnit;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.Cast;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.xplat.XplatAbstractions;

public class TileElvenFluxField
extends TileSyncableTickable
implements ManaReceiver,
SparkAttachable,
IEnergyStorage {
    public static final EnergyUnit BOTANIA_MANA = EnergyUnit.getUnit((String)"botania:mana", (double)(XplatAbstractions.INSTANCE.isForge() ? 10.0 : 3.0));
    @NBTSerializable
    public int mana;
    @NBTSerializable
    public int maxMana = 5000;
    @NBTSerializable
    public final EnergyStorage fe = new EnergyStorage(32000);
    final LazyOptional<?> baseLazy = LazyOptional.of(() -> this);

    public TileElvenFluxField(BlockPos pos, BlockState state) {
        super(TilesBA.ELVEN_FLUX_FIELD, pos, state);
    }

    public void update() {
        int toTransfer;
        int unconsumed;
        int freeFE;
        if (this.isOnClient()) {
            return;
        }
        if (this.mana > 0 && (double)(freeFE = this.fe.getMaxEnergyStored() - this.fe.getEnergyStored()) > TileElvenFluxField.BOTANIA_MANA.toFE) {
            int availableFE = (int)BOTANIA_MANA.getInFE((double)this.mana);
            int receivedFE = this.fe.receiveEnergy(availableFE, false);
            this.receiveMana(-((int)BOTANIA_MANA.getFromFE((double)receivedFE)));
        }
        if (!this.isFull()) {
            SparkUtil.startRequestingMana((BlockEntity)this, this.getAttachedSpark());
        }
        if ((unconsumed = XplatAbstractions.INSTANCE.transferEnergyToNeighbors(this.f_58857_, this.f_58858_, toTransfer = this.fe.getEnergyStored())) != toTransfer) {
            this.fe.extractEnergy(toTransfer - unconsumed, false);
        }
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.f_58858_;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.maxMana - 1000;
    }

    public void receiveMana(int mana) {
        this.mana = Mth.m_14045_((int)(this.mana + mana), (int)0, (int)this.maxMana);
    }

    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.maxMana - this.mana;
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)Cast.cast(sparks.get(0));
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.isFull();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.fe.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.fe.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.fe.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY || cap == BotaniaForgeCapabilities.SPARK_ATTACHABLE || cap == BotaniaForgeCapabilities.MANA_RECEIVER) {
            return this.baseLazy.cast();
        }
        return super.getCapability(cap, side);
    }
}

