/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.block_entity.FloatingFlowerBlockEntity;

public class ForgeFloatingFlowerModel
implements IUnbakedGeometry<ForgeFloatingFlowerModel> {
    public static final ModelProperty<FloatingFlower> FLOATING_PROPERTY = new ModelProperty();
    private final UnbakedModel unbakedFlower;
    private final Map<FloatingFlower.IslandType, UnbakedModel> unbakedIslands = new HashMap<FloatingFlower.IslandType, UnbakedModel>();

    private ForgeFloatingFlowerModel(UnbakedModel flower) {
        this.unbakedFlower = flower;
    }

    @NotNull
    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> ret = new HashSet<Material>();
        for (Map.Entry<FloatingFlower.IslandType, ResourceLocation> e : BotaniaAPIClient.instance().getRegisteredIslandTypeModels().entrySet()) {
            UnbakedModel unbakedIsland = modelGetter.apply(e.getValue());
            ret.addAll(unbakedIsland.m_5500_(modelGetter, missingTextureErrors));
            this.unbakedIslands.put(e.getKey(), unbakedIsland);
        }
        ret.addAll(this.unbakedFlower.m_5500_(modelGetter, missingTextureErrors));
        return ret;
    }

    @Nullable
    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, final ModelState transform, ItemOverrides overrides, ResourceLocation name) {
        Transformation moveFlower = new Transformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null);
        final Transformation mul = moveFlower.m_121096_(transform.m_6189_());
        ModelState newTransform = new ModelState(){

            public Transformation m_6189_() {
                return mul;
            }

            public boolean m_7538_() {
                return transform.m_7538_();
            }
        };
        BakedModel bakedFlower = this.unbakedFlower.m_7611_(bakery, spriteGetter, newTransform, name);
        HashMap<FloatingFlower.IslandType, BakedModel> bakedIslands = new HashMap<FloatingFlower.IslandType, BakedModel>();
        for (Map.Entry<FloatingFlower.IslandType, UnbakedModel> e : this.unbakedIslands.entrySet()) {
            BakedModel bakedIsland = e.getValue().m_7611_(bakery, spriteGetter, transform, name);
            bakedIslands.put(e.getKey(), bakedIsland);
        }
        return new Baked(bakedFlower, bakedIslands);
    }

    public static class Baked
    implements BakedModel {
        private final BakedModel flower;
        private final Map<FloatingFlower.IslandType, BakedModel> islands;

        Baked(BakedModel flower, Map<FloatingFlower.IslandType, BakedModel> islands) {
            this.flower = flower;
            this.islands = islands;
        }

        public boolean m_7541_() {
            return this.flower.m_7541_();
        }

        public boolean m_7539_() {
            return this.flower.m_7539_();
        }

        public boolean m_7547_() {
            return this.flower.m_7547_();
        }

        public boolean m_7521_() {
            return false;
        }

        @NotNull
        public TextureAtlasSprite m_6160_() {
            return this.flower.m_6160_();
        }

        @NotNull
        public ItemOverrides m_7343_() {
            return this.flower.m_7343_();
        }

        @NotNull
        public ItemTransforms m_7442_() {
            return this.flower.m_7442_();
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            SpecialFlowerBlockEntity special;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof FloatingFlowerBlockEntity) {
                FloatingFlowerBlockEntity floating = (FloatingFlowerBlockEntity)be;
                return ModelData.builder().with(FLOATING_PROPERTY, (Object)floating.getFloatingData()).build();
            }
            if (be instanceof SpecialFlowerBlockEntity && (special = (SpecialFlowerBlockEntity)be).isFloating()) {
                return ModelData.builder().with(FLOATING_PROPERTY, (Object)special.getFloatingData()).build();
            }
            return modelData;
        }

        @NotNull
        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
            return this.getQuads(state, side, rand, ModelData.EMPTY, RenderType.m_110463_());
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
            FloatingFlower.IslandType type = FloatingFlower.IslandType.GRASS;
            if (extraData.has(FLOATING_PROPERTY)) {
                type = ((FloatingFlower)extraData.get(FLOATING_PROPERTY)).getIslandType();
            }
            if (renderType != null && state != null && !this.flower.getRenderTypes(state, rand, extraData).contains(renderType)) {
                return this.islands.get(type).getQuads(state, side, rand, ModelData.EMPTY, renderType);
            }
            List flower = this.flower.getQuads(state, side, rand, ModelData.EMPTY, renderType);
            List island = this.islands.get(type).getQuads(state, side, rand, ModelData.EMPTY, renderType);
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>(flower.size() + island.size());
            ret.addAll(flower);
            ret.addAll(island);
            return ret;
        }

        @NotNull
        public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
            return List.of(this.flower, this.islands.get(FloatingFlower.IslandType.GRASS));
        }

        @NotNull
        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{super.getRenderTypes(state, rand, data), this.flower.getRenderTypes(state, rand, data)});
        }
    }

    public static enum Loader implements IGeometryLoader<ForgeFloatingFlowerModel>
    {
        INSTANCE;


        @NotNull
        public ForgeFloatingFlowerModel read(JsonObject model, JsonDeserializationContext ctx) {
            BlockModel flower = (BlockModel)ctx.deserialize((JsonElement)model.getAsJsonObject("flower"), BlockModel.class);
            return new ForgeFloatingFlowerModel((UnbakedModel)flower);
        }
    }
}

