/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.network.serverbound.DodgePacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class RingOfDexterousMotionItem
extends BaubleItem {
    public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
    public static final int MAX_CD = 20;
    private static boolean oldLeftDown;
    private static boolean oldRightDown;
    private static boolean oldForwardDown;
    private static boolean oldBackDown;
    private static int leftDown;
    private static int rightDown;
    private static int forwardDown;
    private static int backDown;

    public RingOfDexterousMotionItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
        if (cd > 0) {
            ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
        }
    }

    private static void dodge(Player player, Direction dir) {
        if (player.m_150110_().f_35935_ || !player.m_20096_() || dir == Direction.UP || dir == Direction.DOWN) {
            return;
        }
        float yaw = player.m_146908_();
        float x = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            x = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180)));
            z = Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
        }
        Vec3 lookVec = new Vec3((double)x, 0.0, (double)z);
        Vec3 sideVec = lookVec.m_82537_(new Vec3(0.0, dir == Direction.WEST || dir == Direction.NORTH ? 1.0 : (double)(dir == Direction.EAST || dir == Direction.SOUTH ? -1 : 0), 0.0)).m_82490_(1.25);
        player.m_20256_(sideVec);
        ClientXplatAbstractions.INSTANCE.sendToServer(DodgePacket.INSTANCE);
    }

    public static class ClientLogic {
        public static void onKeyDown() {
            int oldBack;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            ItemStack ringStack = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)mc.f_91074_);
            if (ringStack.m_41619_() || ItemNBTHelper.getInt(ringStack, RingOfDexterousMotionItem.TAG_DODGE_COOLDOWN, 0) > 0) {
                return;
            }
            int threshold = 5;
            if (mc.f_91066_.f_92086_.m_90857_() && !oldLeftDown) {
                leftDown = ClientTickHandler.ticksInGame;
                int oldLeft = leftDown;
                if (leftDown - oldLeft < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.f_91074_, Direction.WEST);
                }
            } else if (mc.f_91066_.f_92088_.m_90857_() && !oldRightDown) {
                rightDown = ClientTickHandler.ticksInGame;
                int oldRight = rightDown;
                if (rightDown - oldRight < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.f_91074_, Direction.EAST);
                }
            } else if (mc.f_91066_.f_92085_.m_90857_() && !oldForwardDown) {
                forwardDown = ClientTickHandler.ticksInGame;
                int oldForward = forwardDown;
                if (forwardDown - oldForward < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.f_91074_, Direction.NORTH);
                }
            } else if (mc.f_91066_.f_92087_.m_90857_() && !oldBackDown && (backDown = ClientTickHandler.ticksInGame) - (oldBack = backDown) < threshold) {
                RingOfDexterousMotionItem.dodge((Player)mc.f_91074_, Direction.SOUTH);
            }
            oldLeftDown = mc.f_91066_.f_92086_.m_90857_();
            oldRightDown = mc.f_91066_.f_92088_.m_90857_();
            oldForwardDown = mc.f_91066_.f_92085_.m_90857_();
            oldBackDown = mc.f_91066_.f_92087_.m_90857_();
        }

        public static void renderHUD(PoseStack ms, Player player, ItemStack stack, float pticks) {
            int xo = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 20;
            int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + 20;
            if (!player.m_150110_().f_35935_) {
                int cd = ItemNBTHelper.getInt(stack, RingOfDexterousMotionItem.TAG_DODGE_COOLDOWN, 0);
                int width = Math.min((int)(((float)cd - pticks) * 2.0f), 40);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (width > 0) {
                    GuiComponent.m_93172_((PoseStack)ms, (int)xo, (int)(y - 2), (int)(xo + 40), (int)(y - 1), (int)-2013265920);
                    GuiComponent.m_93172_((PoseStack)ms, (int)xo, (int)(y - 2), (int)(xo + width), (int)(y - 1), (int)-1);
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

