/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.CloakModel;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class CloakOfVirtueItem
extends BaubleItem {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/cloak_holy.png");
    private static final ResourceLocation textureGlow = new ResourceLocation("botania:textures/model/cloak_holy_glow.png");
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_IN_EFFECT = "inEffect";

    public CloakOfVirtueItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public float onPlayerDamage(Player player, DamageSource src, float amount) {
        ItemStack stack;
        if (!(src.m_19378_() || (stack = EquipmentHandler.findOrEmpty(this, (LivingEntity)player)).m_41619_() || CloakOfVirtueItem.isInEffect(stack))) {
            CloakOfVirtueItem cloak = (CloakOfVirtueItem)stack.m_41720_();
            int cooldown = CloakOfVirtueItem.getCooldown(stack);
            CloakOfVirtueItem.setInEffect(stack, true);
            MutableFloat mutAmount = new MutableFloat(amount);
            if (cooldown == 0 && cloak.effectOnDamage(src, mutAmount, player, stack)) {
                CloakOfVirtueItem.setCooldown(stack, cloak.getCooldownTime(stack));
            }
            CloakOfVirtueItem.setInEffect(stack, false);
            return mutAmount.getValue().floatValue();
        }
        return amount;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        int cooldown = CloakOfVirtueItem.getCooldown(stack);
        if (cooldown > 0) {
            CloakOfVirtueItem.setCooldown(stack, cooldown - 1);
        }
    }

    protected boolean effectOnDamage(DamageSource src, MutableFloat amount, Player player, ItemStack stack) {
        if (!src.m_19387_()) {
            amount.setValue(0.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.holyCloak, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = player.m_20185_() + Math.random() * (double)player.m_20205_() * 2.0 - (double)player.m_20205_();
                double y = player.m_20186_() + Math.random() * (double)player.m_20206_();
                double z = player.m_20189_() + Math.random() * (double)player.m_20205_() * 2.0 - (double)player.m_20205_();
                boolean yellow = Math.random() > 0.5;
                float r = yellow ? 1.0f : 0.3f;
                float g = yellow ? 1.0f : 0.3f;
                float b = yellow ? 0.3f : 1.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.8f + (float)Math.random() * 0.4f, r, g, b, 3);
                player.m_9236_().m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    public int getCooldownTime(ItemStack stack) {
        return 200;
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }

    public static boolean isInEffect(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_IN_EFFECT, false);
    }

    public static void setInEffect(ItemStack stack, boolean effect) {
        ItemNBTHelper.setBoolean(stack, TAG_IN_EFFECT, effect);
    }

    ResourceLocation getCloakTexture() {
        return texture;
    }

    ResourceLocation getCloakGlowTexture() {
        return textureGlow;
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static CloakModel model = null;

        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            CloakOfVirtueItem item = (CloakOfVirtueItem)stack.m_41720_();
            AccessoryRenderHelper.rotateIfSneaking(ms, living);
            boolean armor = !living.m_6844_(EquipmentSlot.CHEST).m_41619_();
            ms.m_85837_(0.0, armor ? (double)-0.07f : (double)-0.01f, 0.0);
            if (model == null) {
                model = new CloakModel(Minecraft.m_91087_().m_167973_().m_171103_(BotaniaModelLayers.CLOAK));
            }
            VertexConsumer buffer = buffers.m_6299_(model.m_103119_(item.getCloakTexture()));
            model.m_7695_(ms, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            buffer = buffers.m_6299_(model.m_103119_(item.getCloakGlowTexture()));
            model.m_7695_(ms, buffer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

