/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.helper.PlayerHelper;

public class LifeAggregatorItem
extends Item {
    private static final String TAG_SPAWNER = "spawner";
    private static final String TAG_SPAWN_DATA = "SpawnData";
    private static final String TAG_ID = "id";

    public LifeAggregatorItem(Item.Properties props) {
        super(props);
    }

    @Nullable
    private static ResourceLocation getEntityId(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(TAG_SPAWNER);
        if (tag != null && tag.m_128441_(TAG_SPAWN_DATA)) {
            tag = tag.m_128469_(TAG_SPAWN_DATA);
            DataResult spawnData = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            return spawnData.result().filter(sd -> sd.m_186567_().m_128441_(TAG_ID)).map(sd -> ResourceLocation.m_135820_((String)sd.m_186567_().m_128461_(TAG_ID))).orElse(null);
        }
        return null;
    }

    public static boolean hasData(ItemStack stack) {
        return LifeAggregatorItem.getEntityId(stack) != null;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> infoList, TooltipFlag flags) {
        ResourceLocation id = LifeAggregatorItem.getEntityId(stack);
        if (id != null) {
            Registry.f_122826_.m_6612_(id).ifPresent(type -> infoList.add(type.m_20676_()));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (LifeAggregatorItem.getEntityId(ctx.m_43722_()) == null) {
            return this.captureSpawner(ctx) ? InteractionResult.m_19078_((boolean)ctx.m_43725_().m_5776_()) : InteractionResult.PASS;
        }
        return this.placeSpawner(ctx);
    }

    private InteractionResult placeSpawner(UseOnContext ctx) {
        ItemStack useStack = new ItemStack((ItemLike)Blocks.f_50085_);
        Pair<InteractionResult, BlockPos> res = PlayerHelper.substituteUseTrackPos(ctx, useStack);
        if (((InteractionResult)res.getFirst()).m_19077_()) {
            Level world = ctx.m_43725_();
            BlockPos pos = (BlockPos)res.getSecond();
            ItemStack mover = ctx.m_43722_();
            if (!world.f_46443_) {
                if (ctx.m_43723_() != null) {
                    ctx.m_43723_().m_21190_(ctx.m_43724_());
                }
                mover.m_41774_(1);
                BlockEntity te = world.m_7702_(pos);
                if (te instanceof SpawnerBlockEntity) {
                    CompoundTag spawnerTag = ctx.m_43722_().m_41737_(TAG_SPAWNER).m_6426_();
                    spawnerTag.m_128405_("x", pos.m_123341_());
                    spawnerTag.m_128405_("y", pos.m_123342_());
                    spawnerTag.m_128405_("z", pos.m_123343_());
                    te.m_142466_(spawnerTag);
                }
            } else {
                for (int i = 0; i < 100; ++i) {
                    SparkleParticleData data = SparkleParticleData.sparkle(0.45f + 0.2f * (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 6);
                    world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
        return (InteractionResult)res.getFirst();
    }

    private boolean captureSpawner(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        if (world.m_8055_(pos).m_60713_(Blocks.f_50085_)) {
            if (!world.f_46443_) {
                BlockEntity te = world.m_7702_(pos);
                stack.m_41784_().m_128365_(TAG_SPAWNER, (Tag)te.m_187480_());
                world.m_46961_(pos, false);
                if (player != null) {
                    player.m_36335_().m_41524_((Item)this, 20);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        UseItemSuccessTrigger.INSTANCE.trigger(serverPlayer, stack, serverPlayer.m_9236_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    }
                    player.m_21190_(ctx.m_43724_());
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.1f + 0.05f, red, green, blue);
                    world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f), (double)((float)(Math.random() - 0.5) * 0.15f));
                }
            }
            return true;
        }
        return false;
    }
}

