/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlock
extends BotaniaBlock
implements EntityBlock {
    public static final EnumProperty<PetalApothecary.State> FLUID = EnumProperty.m_61587_((String)"fluid", PetalApothecary.State.class);
    private static final VoxelShape BASE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape TOP = Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_INTERACT = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)PILLAR), (VoxelShape)TOP);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)SHAPE_INTERACT, (VoxelShape)TOP_CUTOUT, (BooleanOp)BooleanOp.f_82685_);
    public final Variant variant;

    protected PetalApothecaryBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FLUID, (Comparable)((Object)PetalApothecary.State.EMPTY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FLUID});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE_INTERACT;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            PetalApothecaryBlockEntity tile = (PetalApothecaryBlockEntity)world.m_7702_(pos);
            if (tile.collideEntityItem(itemEntity)) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof PetalApothecaryBlockEntity)) {
            return InteractionResult.PASS;
        }
        PetalApothecaryBlockEntity apothecary = (PetalApothecaryBlockEntity)blockEntity;
        boolean mainHandEmpty = player.m_21205_().m_41619_();
        if (apothecary.canAddLastRecipe() && mainHandEmpty) {
            return apothecary.trySetLastRecipe(player);
        }
        if (!apothecary.isEmpty() && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(apothecary, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(apothecary);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.tryWithdrawFluid(player, hand, apothecary, pos) || this.tryDepositFluid(player, hand, apothecary, pos)) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (world.f_46441_.m_188503_(20) == 1 && state.m_61143_(FLUID) == PetalApothecary.State.EMPTY) {
            world.m_46597_(pos, (BlockState)state.m_61124_(FLUID, (Comparable)((Object)PetalApothecary.State.WATER)));
        }
    }

    private boolean tryWithdrawFluid(Player player, InteractionHand hand, PetalApothecaryBlockEntity altar, BlockPos pos) {
        Fluid fluid = altar.getFluid().asVanilla();
        if (fluid == Fluids.f_76191_ || fluid == Fluids.f_76193_ && XplatAbstractions.INSTANCE.gogLoaded()) {
            return false;
        }
        boolean success = XplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
        if (success) {
            altar.setFluid(PetalApothecary.State.EMPTY);
            if (fluid == Fluids.f_76193_) {
                player.m_9236_().m_5594_(player, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (fluid == Fluids.f_76195_) {
                player.m_9236_().m_5594_(player, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return success;
    }

    private boolean tryDepositFluid(Player player, InteractionHand hand, PetalApothecaryBlockEntity altar, BlockPos pos) {
        if (altar.getFluid() != PetalApothecary.State.EMPTY) {
            return false;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150930_(BotaniaItems.waterRod) && ManaItemHandler.instance().requestManaExact(stack, player, 75, false)) {
            ManaItemHandler.instance().requestManaExact(stack, player, 75, true);
            altar.setFluid(PetalApothecary.State.WATER);
            player.m_9236_().m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76193_)) {
            altar.setFluid(PetalApothecary.State.WATER);
            player.m_9236_().m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76195_)) {
            altar.setFluid(PetalApothecary.State.LAVA);
            player.m_9236_().m_5594_(player, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PetalApothecaryBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return PetalApothecaryBlock.createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::clientTick);
        }
        return PetalApothecaryBlock.createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::serverTick);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        boolean blockChanged;
        boolean bl = blockChanged = !state.m_60713_(newState.m_60734_());
        if (blockChanged || newState.m_61143_(FLUID) != PetalApothecary.State.WATER) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            if (blockChanged) {
                super.m_6810_(state, world, pos, newState, isMoving);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return state.m_61143_(FLUID) == PetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY,
        LIVINGROCK,
        DEEPSLATE;

    }
}

