/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CompositeLensRecipeWrapper
implements ICraftingCategoryExtension {
    private final List<Item> allLenses = StreamSupport.stream(Registry.f_122827_.m_206058_(BotaniaTags.Items.LENS).spliterator(), false).map(ItemStack::new).filter(s -> !((LensItem)s.m_41720_()).isControlLens((ItemStack)s)).filter(s -> ((LensItem)s.m_41720_()).isCombinable((ItemStack)s)).map(ItemStack::m_41720_).toList();

    public CompositeLensRecipeWrapper(CompositeLensRecipe recipe) {
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper helper, @NotNull IFocusGroup focusGroup) {
        List<Item> possibleFirstLenses = focusGroup.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).filter(f -> this.allLenses.contains(((ItemStack)f.getTypedValue().getIngredient()).m_41720_())).map(f -> ((ItemStack)f.getTypedValue().getIngredient()).m_41720_()).toList();
        if (possibleFirstLenses.isEmpty()) {
            possibleFirstLenses = this.allLenses;
        }
        ArrayList<ItemStack> firstInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (Item firstLens : possibleFirstLenses) {
            ItemStack firstLensStack = new ItemStack((ItemLike)firstLens);
            for (Item secondLens : this.allLenses) {
                ItemStack secondLensStack;
                if (secondLens == firstLens || !((LensItem)firstLens).canCombineLenses(firstLensStack, secondLensStack = new ItemStack((ItemLike)secondLens))) continue;
                firstInput.add(firstLensStack);
                secondInput.add(secondLensStack);
                outputs.add(((LensItem)firstLens).setCompositeLens(firstLensStack.m_41777_(), secondLensStack));
            }
        }
        helper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, List.of(firstInput, List.of(new ItemStack((ItemLike)Items.f_42518_)), secondInput), 0, 0);
        helper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, outputs);
    }
}

