/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolRecipeCategory
implements IRecipeCategory<ManaInfusionRecipe> {
    public static final RecipeType<ManaInfusionRecipe> TYPE = RecipeType.create((String)"botania", (String)"mana_pool", ManaInfusionRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)BotaniaBlocks.manaPool);

    public ManaPoolRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 55);
        this.localizedName = Component.m_237115_((String)"botania.nei.manaPool");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        ItemNBTHelper.setBoolean(this.renderStack, "RenderFull", true);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack.m_41777_());
    }

    @NotNull
    public RecipeType<ManaInfusionRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ManaInfusionRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 40, 0);
        HUDHandler.renderManaBar(ms, 20, 50, 255, 0.75f, recipe.getManaToConsume(), 100000);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ManaInfusionRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 12).addIngredients((Ingredient)recipe.m_7527_().get(0));
        StateIngredient catalyst = recipe.getRecipeCatalyst();
        if (catalyst != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 12, 12).addItemStacks(catalyst.getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(catalyst.descriptionTooltip()));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 12).addItemStack(this.renderStack);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 12).addItemStack(recipe.m_8043_());
    }
}

