/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BreweryRecipeCategory
implements IRecipeCategory<BotanicalBreweryRecipe> {
    public static final RecipeType<BotanicalBreweryRecipe> TYPE = RecipeType.create((String)"botania", (String)"brewery", BotanicalBreweryRecipe.class);
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final Component localizedName;

    public BreweryRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocationHelper.prefix("textures/gui/nei_brewery.png");
        this.background = guiHelper.createDrawable(location, 28, 6, 131, 55);
        this.localizedName = Component.m_237115_((String)"botania.nei.brewery");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaBlocks.brewery));
    }

    @NotNull
    public RecipeType<BotanicalBreweryRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BotanicalBreweryRecipe recipe, @NotNull IFocusGroup focuses) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (ItemStack container : new ItemStack[]{new ItemStack((ItemLike)BotaniaItems.vial), new ItemStack((ItemLike)BotaniaItems.flask), new ItemStack((ItemLike)BotaniaItems.incenseStick), new ItemStack((ItemLike)BotaniaItems.bloodPendant)}) {
            ItemStack brewed = recipe.getOutput(container);
            if (brewed.m_41619_()) continue;
            containers.add(container);
            outputs.add(brewed);
        }
        IFocus outputFocus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).findAny().orElse(null);
        IFocus inputFocus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).findAny().orElse(null);
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 36).addItemStacks(this.getItemMatchingFocus((IFocus<ItemStack>)outputFocus, outputs, containers));
        NonNullList inputs = recipe.m_7527_();
        int posX = 67 - inputs.size() * 9;
        for (Ingredient ingr : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, posX, 0).addIngredients(ingr);
            posX += 18;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 36).addItemStacks(this.getItemMatchingFocus((IFocus<ItemStack>)inputFocus, containers, outputs));
    }

    private List<ItemStack> getItemMatchingFocus(IFocus<ItemStack> focus, List<ItemStack> focused, List<ItemStack> other) {
        if (focus != null) {
            ItemStack focusStack = (ItemStack)focus.getTypedValue().getIngredient();
            for (int i = 0; i < focused.size(); ++i) {
                if (!focusStack.m_41656_(focused.get(i))) continue;
                return Collections.singletonList(other.get(i));
            }
        }
        return other;
    }
}

