/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner;

import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.data.BlockSpeedManager;
import fuzs.blockrunner.data.ModBlockTagsProvider;
import fuzs.blockrunner.data.ModLanguageProvider;
import fuzs.puzzleslib.core.CoreServices;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="blockrunner")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRunnerForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("blockrunner").accept(new BlockRunner());
        BlockRunnerForge.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.addListener((PreparableReloadListener)BlockSpeedManager.INSTANCE));
        MinecraftForge.EVENT_BUS.addListener(evt -> BlockSpeedManager.INSTANCE.onPlayerLoggedIn(evt.getEntity()));
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator dataGenerator = evt.getGenerator();
        ExistingFileHelper fileHelper = evt.getExistingFileHelper();
        dataGenerator.m_236039_(true, (DataProvider)new ModBlockTagsProvider(dataGenerator, "blockrunner", fileHelper));
        dataGenerator.m_236039_(true, (DataProvider)new ModLanguageProvider(dataGenerator, "blockrunner"));
    }
}

