/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.apicalls.ApiCalls;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.PlanService;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.RamRecommendations;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class ApiData {
    private static final String JAR_GROUP_URL = "https://www.bisecthosting.com/config-minecraft-modpacksapi.php?whmcs=overwolf";
    private static final String PLANS_URL = "https://www.bisecthosting.com/overwolfPlans.json";
    private static final String RAM_RECOMMENDATION_URL = "https://www.bisecthosting.com/config-minecraft-modpack-ramsapi.php?res=json";
    public static final Map<String, JarGroupData> AVAILABLE_GROUPS = new HashMap<String, JarGroupData>();
    public static final Map<String, JarGroupData.JarData> AVAILABLE_JARS = new HashMap<String, JarGroupData.JarData>();
    public static final Map<String, RamRecommendations> RAM_RECOMMENDATIONS = new HashMap<String, RamRecommendations>();
    public static Pair<PlanService, PlanService> PLANS;

    public static CompletableFuture<Void> reloadData() {
        AVAILABLE_GROUPS.clear();
        AVAILABLE_JARS.clear();
        RAM_RECOMMENDATIONS.clear();
        CompletableFuture[] completableFutureArray = new CompletableFuture[3];
        completableFutureArray[0] = CompletableFuture.supplyAsync(ApiData::loadJars).thenAccept(a -> {
            AVAILABLE_GROUPS.putAll((Map<String, JarGroupData>)a);
            AVAILABLE_JARS.putAll(a.values().stream().flatMap(group -> group.premiumJars.values().stream()).collect(Collectors.toMap(jar -> jar.premiumJarId, Function.identity())));
        });
        completableFutureArray[1] = CompletableFuture.supplyAsync(ApiData::loadPlans).thenAccept(a -> {
            PLANS = a;
        });
        completableFutureArray[2] = CompletableFuture.supplyAsync(ApiData::loadRamRecommendations).thenAccept(RAM_RECOMMENDATIONS::putAll);
        return CompletableFuture.allOf(completableFutureArray);
    }

    public static Map<String, JarGroupData> loadJars() {
        try {
            ModRef.LOGGER.info("Loading available jars");
            HashMap<String, JarGroupData> map = new HashMap<String, JarGroupData>();
            URLConnection urlConnection = new URL(JAR_GROUP_URL).openConnection();
            urlConnection.setRequestProperty("User-Agent", "BisectHosting Overwolf App");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            urlConnection.setRequestProperty("Pragma", "no-cache");
            JsonObject json = (JsonObject)ApiCalls.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(urlConnection.getInputStream())), JsonObject.class);
            json.entrySet().forEach(entry -> {
                JarGroupData jarGroupData = null;
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    jarGroupData = JarGroupData.fromJson((String)entry.getKey(), (JsonObject)entry.getValue());
                } else if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    jarGroupData = JarGroupData.fromString((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                if (jarGroupData != null) {
                    map.put(jarGroupData.name, jarGroupData);
                }
            });
            ModRef.LOGGER.info("Found {} jars", (Object)map.values().stream().mapToLong(group -> group.premiumJars.values().size()).sum());
            return map;
        }
        catch (IOException e) {
            ModRef.LOGGER.warn("Could not load jar data from BH servers", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public static Pair<PlanService, PlanService> loadPlans() {
        try {
            ModRef.LOGGER.info("Loading plans");
            URLConnection urlConnection = new URL(PLANS_URL).openConnection();
            urlConnection.setRequestProperty("User-Agent", "BisectHosting Overwolf App");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            urlConnection.setRequestProperty("Pragma", "no-cache");
            JsonObject json = (JsonObject)ApiCalls.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(urlConnection.getInputStream())), JsonObject.class);
            JsonObject results = json.getAsJsonObject("results");
            PlanService premiumPlans = (PlanService)ApiCalls.GSON.fromJson(results.get("premium"), PlanService.class);
            PlanService budgetPlans = (PlanService)ApiCalls.GSON.fromJson(results.get("budget"), PlanService.class);
            ModRef.LOGGER.info("Found {} plans", (Object)premiumPlans.plans.size());
            return Pair.of((Object)premiumPlans, (Object)budgetPlans);
        }
        catch (IOException e) {
            ModRef.LOGGER.warn("Could not load plan data from BH servers", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public static Map<String, RamRecommendations> loadRamRecommendations() {
        try {
            ModRef.LOGGER.info("Loading ram recommendations");
            HashMap<String, RamRecommendations> map = new HashMap<String, RamRecommendations>();
            URLConnection urlConnection = new URL(RAM_RECOMMENDATION_URL).openConnection();
            urlConnection.setRequestProperty("User-Agent", "BisectHosting Overwolf App");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            urlConnection.setRequestProperty("Pragma", "no-cache");
            JsonObject json = (JsonObject)ApiCalls.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(urlConnection.getInputStream())), JsonObject.class);
            json.entrySet().forEach(entry -> {
                JsonObject ramJson = new JsonObject();
                ramJson.add("ramData", (JsonElement)entry.getValue());
                map.put((String)entry.getKey(), (RamRecommendations)ApiCalls.GSON.fromJson((JsonElement)ramJson, RamRecommendations.class));
            });
            ModRef.LOGGER.info("Found recommendations for {} total jars", (Object)map.size());
            return map;
        }
        catch (IOException e) {
            ModRef.LOGGER.warn("Could not load plan data from BH servers", (Throwable)e);
            throw new RuntimeException();
        }
    }
}

