/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.core.attributeslib.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.core.attributeslib.AttributesLib;
import shadows.apotheosis.core.attributeslib.api.AddAttributeTooltipsEvent;
import shadows.apotheosis.core.attributeslib.api.AttributeHelper;
import shadows.apotheosis.core.attributeslib.api.GatherEffectScreenTooltipsEvent;
import shadows.apotheosis.core.attributeslib.api.GatherSkippedAttributeTooltipsEvent;
import shadows.apotheosis.core.attributeslib.api.IFormattableAttribute;
import shadows.apotheosis.core.attributeslib.client.AttributesGui;

public class AttributesLibClient {
    private static final UUID FAKE_MERGED_UUID = UUID.fromString("a6b0ac71-e435-416e-a991-7623eaa129a4");

    @SubscribeEvent
    public static void particleFactories(RegisterParticleProvidersEvent e) {
        e.register((ParticleType)Apoth.Particles.APOTH_CRIT.get(), ApothCritProvider::new);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        List list = e.getToolTip();
        int markIdx1 = -1;
        int markIdx2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            ComponentContents componentContents = ((Component)list.get(i)).m_214077_();
            if (!(componentContents instanceof LiteralContents)) continue;
            LiteralContents tc = (LiteralContents)componentContents;
            if ("APOTH_REMOVE_MARKER".equals(tc.f_237368_())) {
                markIdx1 = i;
            }
            if (!"APOTH_REMOVE_MARKER_2".equals(tc.f_237368_())) continue;
            markIdx2 = i;
            break;
        }
        if (markIdx1 == -1 || markIdx2 == -1) {
            return;
        }
        ListIterator<Component> it = list.listIterator(markIdx1);
        for (int i = markIdx1; i < markIdx2 + 1; ++i) {
            it.next();
            it.remove();
        }
        int flags = AttributesLibClient.getHideFlags(stack);
        if (AttributesLibClient.shouldShowInTooltip(flags, ItemStack.TooltipPart.MODIFIERS)) {
            AttributesLibClient.applyModifierTooltips(e.getEntity(), stack, it::add, e.getFlags());
        }
        MinecraftForge.EVENT_BUS.post((Event)new AddAttributeTooltipsEvent(stack, e.getEntity(), list, it, e.getFlags()));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addAttribComponent(ScreenEvent.Init.Post e) {
        Screen screen = e.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen scn = (InventoryScreen)screen;
            AttributesGui atrComp = new AttributesGui(scn);
            e.addListener((GuiEventListener)atrComp);
            e.addListener((GuiEventListener)atrComp.toggleBtn);
            e.addListener((GuiEventListener)atrComp.hideUnchangedBtn);
            if (AttributesGui.wasOpen) {
                atrComp.toggleVisibility();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void effectGuiTooltips(GatherEffectScreenTooltipsEvent e) {
        String key;
        List<Component> tooltips = e.getTooltip();
        MobEffectInstance effectInst = e.getEffectInstance();
        MobEffect effect = effectInst.m_19544_();
        MutableComponent name = (MutableComponent)tooltips.get(0);
        Component duration = tooltips.remove(1);
        duration = Component.m_237110_((String)"(%s)", (Object[])new Object[]{duration}).m_130940_(ChatFormatting.WHITE);
        name.m_130946_(" ").m_7220_(duration);
        if (AttributesLib.getTooltipFlag().m_7050_()) {
            name.m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Registry.f_122823_.m_7981_((Object)effect)}).m_130940_(ChatFormatting.GRAY));
        }
        if (I18n.m_118936_((String)(key = effect.m_19481_() + ".desc"))) {
            tooltips.add((Component)Component.m_237115_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        } else if (AttributesLib.getTooltipFlag().m_7050_() && effect.m_19485_().isEmpty()) {
            tooltips.add((Component)Component.m_237115_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        ArrayList list = Lists.newArrayList();
        Map map = effect.m_19485_();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInst.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                list.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
            }
        }
        if (!list.isEmpty()) {
            tooltips.add(CommonComponents.f_237098_);
            for (Pair pair : list) {
                tooltips.add((Component)IFormattableAttribute.toComponent((Attribute)pair.getFirst(), (AttributeModifier)pair.getSecond(), AttributesLib.getTooltipFlag()));
            }
        }
    }

    @SubscribeEvent
    public void potionTooltips(ItemTooltipEvent e) {
        List effects;
        ItemStack stack = e.getItemStack();
        List tooltips = e.getToolTip();
        if (stack.m_41720_() instanceof PotionItem && (effects = PotionUtils.m_43547_((ItemStack)stack)).size() == 1 && tooltips.size() >= 2) {
            MobEffect effect = ((MobEffectInstance)effects.get(0)).m_19544_();
            String key = effect.m_19481_() + ".desc";
            if (I18n.m_118936_((String)key)) {
                tooltips.add(2, Component.m_237115_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
                tooltips.add(3, CommonComponents.f_237098_);
            } else if (e.getFlags().m_7050_() && effect.m_19485_().isEmpty()) {
                tooltips.add(2, Component.m_237115_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                tooltips.add(3, CommonComponents.f_237098_);
            }
        }
    }

    public static Multimap<Attribute, AttributeModifier> getSortedModifiers(ItemStack stack, EquipmentSlot slot) {
        Multimap unsorted = stack.m_41638_(slot);
        Multimap<Attribute, AttributeModifier> map = AttributeHelper.sortedMap();
        for (Map.Entry ent : unsorted.entries()) {
            if (ent.getKey() != null && ent.getValue() != null) {
                map.put((Object)((Attribute)ent.getKey()), (Object)((AttributeModifier)ent.getValue()));
                continue;
            }
            AdventureModule.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, ent.getKey(), ent.getValue());
        }
        return map;
    }

    public static void apothCrit(int entityId) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
        if (entity != null) {
            Minecraft.m_91087_().f_91061_.m_107329_(entity, (ParticleOptions)Apoth.Particles.APOTH_CRIT.get());
        }
    }

    private static boolean shouldShowInTooltip(int pHideFlags, ItemStack.TooltipPart pPart) {
        return (pHideFlags & pPart.m_41809_()) == 0;
    }

    private static int getHideFlags(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : stack.m_41720_().getDefaultTooltipHideFlags(stack);
    }

    private static void applyModifierTooltips(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, TooltipFlag flag) {
        Multimap<Attribute, AttributeModifier> mainhand = AttributesLibClient.getSortedModifiers(stack, EquipmentSlot.MAINHAND);
        Multimap<Attribute, AttributeModifier> offhand = AttributesLibClient.getSortedModifiers(stack, EquipmentSlot.OFFHAND);
        Multimap<Attribute, AttributeModifier> dualHand = AttributeHelper.sortedMap();
        for (Attribute atr : mainhand.keys()) {
            Collection modifMh = mainhand.get((Object)atr);
            Collection modifOh = offhand.get((Object)atr);
            modifMh.stream().filter(a1 -> modifOh.stream().anyMatch(a2 -> a1.m_22209_().equals(a2.m_22209_()))).forEach(modif -> dualHand.put((Object)atr, modif));
        }
        dualHand.values().forEach(m -> {
            mainhand.values().remove(m);
            offhand.values().removeIf(m1 -> m1.m_22209_().equals(m.m_22209_()));
        });
        HashSet<UUID> skips = new HashSet<UUID>();
        MinecraftForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, player, skips, flag));
        AttributesLibClient.applyTextFor(player, stack, tooltip, dualHand, "both_hands", skips, flag);
        AttributesLibClient.applyTextFor(player, stack, tooltip, mainhand, EquipmentSlot.MAINHAND.m_20751_(), skips, flag);
        AttributesLibClient.applyTextFor(player, stack, tooltip, offhand, EquipmentSlot.OFFHAND.m_20751_(), skips, flag);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.ordinal() < 2) continue;
            Multimap<Attribute, AttributeModifier> modifiers = AttributesLibClient.getSortedModifiers(stack, slot);
            AttributesLibClient.applyTextFor(player, stack, tooltip, modifiers, slot.m_20751_(), skips, flag);
        }
    }

    private static MutableComponent padded(String padding, Component comp) {
        return Component.m_237113_((String)padding).m_7220_(comp);
    }

    private static MutableComponent list() {
        return AttributeHelper.list();
    }

    private static void applyTextFor(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, Multimap<Attribute, AttributeModifier> modifierMap, String group, Set<UUID> skips, TooltipFlag flag) {
        if (!modifierMap.isEmpty()) {
            modifierMap.values().removeIf(m -> skips.contains(m.m_22209_()));
            tooltip.accept((Component)Component.m_237119_());
            tooltip.accept((Component)Component.m_237115_((String)("item.modifiers." + group)).m_130940_(ChatFormatting.GRAY));
            if (modifierMap.isEmpty()) {
                return;
            }
            IdentityHashMap baseModifs = new IdentityHashMap();
            modifierMap.forEach((attr, modif) -> {
                if (modif.m_22209_().equals(((IFormattableAttribute)attr).getBaseUUID())) {
                    baseModifs.put(attr, new BaseModifier((AttributeModifier)modif, (List<AttributeModifier>)new ArrayList<AttributeModifier>()));
                }
            });
            modifierMap.forEach((attr, modif) -> {
                BaseModifier base = (BaseModifier)baseModifs.get(attr);
                if (base != null && base.base != modif) {
                    base.children.add((AttributeModifier)modif);
                }
            });
            for (Map.Entry entry : baseModifs.entrySet()) {
                double base;
                Attribute attr2 = (Attribute)entry.getKey();
                BaseModifier baseModif = (BaseModifier)entry.getValue();
                double entityBase = player == null ? 0.0 : player.m_21172_(attr2);
                double rawBase = base = baseModif.base.m_22218_() + entityBase;
                double amt = base;
                double baseBonus = ((IFormattableAttribute)attr2).getBonusBaseValue(stack);
                for (AttributeModifier modif2 : baseModif.children) {
                    if (modif2.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        base = amt += modif2.m_22218_();
                        continue;
                    }
                    if (modif2.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        amt += modif2.m_22218_() * base;
                        continue;
                    }
                    amt *= 1.0 + modif2.m_22218_();
                }
                boolean isMerged = !baseModif.children.isEmpty() || baseBonus != 0.0;
                MutableComponent text = IFormattableAttribute.toBaseComponent(attr2, amt += baseBonus, entityBase, isMerged, flag);
                tooltip.accept((Component)AttributesLibClient.padded(" ", (Component)text).m_130940_(isMerged ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN));
                if (!Screen.m_96638_() || !isMerged) continue;
                text = IFormattableAttribute.toBaseComponent(attr2, rawBase, entityBase, false, flag);
                tooltip.accept((Component)AttributesLibClient.list().m_7220_((Component)text.m_130940_(ChatFormatting.DARK_GREEN)));
                for (AttributeModifier modifier : baseModif.children) {
                    tooltip.accept((Component)AttributesLibClient.list().m_7220_((Component)IFormattableAttribute.toComponent(attr2, modifier, flag)));
                }
                if (!(baseBonus > 0.0)) continue;
                ((IFormattableAttribute)attr2).addBonusTooltips(stack, tooltip, flag);
            }
            for (Attribute attr3 : modifierMap.keySet()) {
                if (baseModifs.containsKey(attr3)) continue;
                Collection modifs = modifierMap.get((Object)attr3);
                if (modifs.size() > 1) {
                    double[] sums = new double[3];
                    boolean[] merged = new boolean[3];
                    HashMap<AttributeModifier.Operation, List> shiftExpands = new HashMap<AttributeModifier.Operation, List>();
                    for (AttributeModifier modifier : modifs) {
                        if (modifier.m_22218_() == 0.0) continue;
                        if (sums[modifier.m_22217_().ordinal()] != 0.0) {
                            merged[modifier.m_22217_().ordinal()] = true;
                        }
                        int n = modifier.m_22217_().ordinal();
                        sums[n] = sums[n] + modifier.m_22218_();
                        shiftExpands.computeIfAbsent(modifier.m_22217_(), k -> new LinkedList()).add(modifier);
                    }
                    for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
                        int i = op.ordinal();
                        if (sums[i] == 0.0) continue;
                        if (merged[i]) {
                            TextColor color;
                            TextColor textColor = color = sums[i] < 0.0 ? TextColor.m_131266_((int)16331057) : TextColor.m_131266_((int)8026873);
                            if (sums[i] < 0.0) {
                                int n = i;
                                sums[n] = sums[n] * -1.0;
                            }
                            AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_UUID, () -> "attributeslib:merged", sums[i], op);
                            MutableComponent comp = IFormattableAttribute.toComponent(attr3, fakeModif, flag);
                            tooltip.accept((Component)comp.m_130948_(comp.m_7383_().m_131148_(color)));
                            if (!merged[i] || !Screen.m_96638_()) continue;
                            ((List)shiftExpands.get(AttributeModifier.Operation.m_22236_((int)i))).forEach(modif -> tooltip.accept((Component)AttributesLibClient.list().m_7220_((Component)IFormattableAttribute.toComponent(attr3, modif, flag))));
                            continue;
                        }
                        AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_UUID, () -> "attributeslib:merged", sums[i], op);
                        tooltip.accept((Component)IFormattableAttribute.toComponent(attr3, fakeModif, flag));
                    }
                    continue;
                }
                modifs.forEach(m -> {
                    if (m.m_22218_() != 0.0) {
                        tooltip.accept((Component)IFormattableAttribute.toComponent(attr3, m, flag));
                    }
                });
            }
        }
    }

    private record BaseModifier(AttributeModifier base, List<AttributeModifier> children) {
    }

    public static class ApothCritParticle
    extends CritParticle {
        public ApothCritParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            this.f_107229_ = 1.0f;
            this.f_107227_ = 0.3f;
            this.f_107228_ = 0.8f;
        }
    }

    public static class ApothCritProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ApothCritProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            ApothCritParticle critparticle = new ApothCritParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            critparticle.m_108335_(this.sprite);
            return critparticle;
        }
    }
}

