/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.core.attributeslib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.core.attributeslib.AttributesLib;
import shadows.apotheosis.core.attributeslib.api.IFormattableAttribute;
import shadows.apotheosis.core.attributeslib.client.AttributeModifierComponent;
import shadows.apotheosis.core.attributeslib.client.ModifierSource;
import shadows.apotheosis.core.attributeslib.client.ModifierSourceType;
import shadows.placebo.PlaceboClient;

public class AttributesGui
extends GuiComponent
implements Widget,
GuiEventListener {
    public static final ResourceLocation TEXTURES = Apotheosis.loc("textures/gui/attributes_gui.png");
    public static final int ENTRY_HEIGHT = 22;
    public static final int MAX_ENTRIES = 6;
    public static final int WIDTH = 131;
    public static boolean wasOpen = false;
    protected static float scrollOffset = 0.0f;
    protected static boolean hideUnchanged = false;
    protected final InventoryScreen parent;
    protected final Player player;
    protected final Font font;
    protected final ImageButton toggleBtn;
    protected final ImageButton recipeBookButton;
    protected final HideUnchangedButton hideUnchangedBtn;
    protected int leftPos;
    protected int topPos;
    protected boolean scrolling;
    protected int startIndex;
    protected List<AttributeInstance> data;
    @Nullable
    protected AttributeInstance selected;
    protected boolean open;
    protected long lastRenderTick;
    private static DecimalFormat f = ItemStack.f_41584_;

    public AttributesGui(InventoryScreen parent) {
        ImageButton imgBtn;
        GuiEventListener btn2;
        this.font = Minecraft.m_91087_().f_91062_;
        this.data = new ArrayList<AttributeInstance>();
        this.selected = null;
        this.open = false;
        this.lastRenderTick = -1L;
        this.parent = parent;
        this.player = Minecraft.m_91087_().f_91074_;
        this.refreshData();
        this.leftPos = parent.getGuiLeft() - 131;
        this.topPos = parent.getGuiTop();
        this.toggleBtn = new ImageButton(parent.getGuiLeft() + 63, parent.getGuiTop() + 10, 10, 10, 131, 0, 10, TEXTURES, 256, 256, btn -> this.toggleVisibility(), (Component)Component.m_237115_((String)"attributeslib.gui.show_attributes"));
        this.recipeBookButton = this.parent.m_6702_().size() > 1 ? ((btn2 = (GuiEventListener)this.parent.m_6702_().get(0)) instanceof ImageButton ? (imgBtn = (ImageButton)btn2) : null) : null;
        this.hideUnchangedBtn = new HideUnchangedButton(0, 0);
    }

    public void refreshData() {
        this.data.clear();
        ForgeRegistries.ATTRIBUTES.getValues().stream().map(arg_0 -> ((Player)this.player).m_21051_(arg_0)).filter(Objects::nonNull).filter(ai -> {
            if (!hideUnchanged) {
                return true;
            }
            return ai.m_22115_() != ai.m_22135_();
        }).forEach(this.data::add);
        this.data.sort(this::compareAttrs);
        this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
    }

    public void toggleVisibility() {
        boolean bl = this.open = !this.open;
        if (this.open && this.parent.m_5564_().m_100385_()) {
            this.parent.m_5564_().m_100384_();
        }
        this.hideUnchangedBtn.f_93624_ = this.open;
        int newLeftPos = this.open && this.parent.f_96543_ >= 379 ? 177 + (this.parent.f_96543_ - this.parent.f_97726_ - 200) / 2 : (this.parent.f_96543_ - this.parent.f_97726_) / 2;
        this.parent.f_97735_ = newLeftPos;
        this.leftPos = this.parent.getGuiLeft() - 131;
        this.topPos = this.parent.getGuiTop();
        if (this.recipeBookButton != null) {
            this.recipeBookButton.m_94278_(this.parent.getGuiLeft() + 104, this.parent.f_96544_ / 2 - 22);
        }
        this.hideUnchangedBtn.m_94278_(this.leftPos + 7, this.topPos + 151);
    }

    protected int compareAttrs(AttributeInstance a1, AttributeInstance a2) {
        String name = I18n.m_118938_((String)a1.m_22099_().m_22087_(), (Object[])new Object[0]);
        String name2 = I18n.m_118938_((String)a2.m_22099_().m_22087_(), (Object[])new Object[0]);
        return name.compareTo(name2);
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        if (!this.open) {
            return false;
        }
        return this.isHovering(0, 0, 131, 166, pMouseX, pMouseY);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.toggleBtn.f_93620_ = this.parent.getGuiLeft() + 63;
        this.toggleBtn.f_93621_ = this.parent.getGuiTop() + 10;
        if (this.parent.m_5564_().m_100385_()) {
            this.open = false;
        }
        wasOpen = this.open;
        if (!this.open) {
            return;
        }
        if (this.lastRenderTick != PlaceboClient.ticks) {
            this.lastRenderTick = PlaceboClient.ticks;
            this.refreshData();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        int left = this.leftPos;
        int top = this.topPos;
        this.m_93228_(stack, left, top, 0, 0, 131, 166);
        int scrollbarPos = (int)(117.0f * scrollOffset);
        this.m_93228_(stack, left + 111, top + 16 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 6 && idx < this.data.size(); ++idx) {
            this.renderEntry(stack, this.data.get(idx), this.leftPos + 8, this.topPos + 16 + 22 * (idx - this.startIndex), mouseX, mouseY);
        }
        this.renderTooltip(stack, mouseX, mouseY);
        this.font.m_92889_(stack, (Component)Component.m_237115_((String)"attributeslib.gui.attributes"), (float)(this.leftPos + 8), (float)(this.topPos + 5), 0x404040);
        this.font.m_92889_(stack, (Component)Component.m_237113_((String)"Hide Unchanged"), (float)(this.leftPos + 20), (float)(this.topPos + 152), 0x404040);
    }

    protected void renderTooltip(PoseStack stack, int mouseX, int mouseY) {
        AttributeInstance inst = this.getHoveredSlot(mouseX, mouseY);
        if (inst != null) {
            Attribute attr = inst.m_22099_();
            IFormattableAttribute fAttr = (IFormattableAttribute)attr;
            ArrayList<Object> list = new ArrayList<Object>();
            MutableComponent name = Component.m_237115_((String)attr.m_22087_()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131162_(Boolean.valueOf(true)));
            if (AttributesLib.getTooltipFlag().m_7050_()) {
                Style style = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131162_(Boolean.valueOf(false));
                name.m_7220_((Component)Component.m_237113_((String)(" [" + Registry.f_122866_.m_7981_((Object)attr).toString() + "]")).m_130948_(style));
            }
            list.add(name);
            String key = attr.m_22087_() + ".desc";
            if (I18n.m_118936_((String)key)) {
                txt = Component.m_237115_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
                list.add(txt);
            } else if (AttributesLib.getTooltipFlag().m_7050_()) {
                txt = Component.m_237113_((String)key).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                list.add(txt);
            }
            list.add(CommonComponents.f_237098_);
            ChatFormatting color = ChatFormatting.GRAY;
            if (attr instanceof RangedAttribute) {
                RangedAttribute ra = (RangedAttribute)attr;
                if (inst.m_22135_() > inst.m_22115_()) {
                    color = ChatFormatting.YELLOW;
                } else if (inst.m_22135_() < inst.m_22115_()) {
                    color = ChatFormatting.RED;
                }
            }
            MutableComponent valueComp = fAttr.toValueComponent(AttributeModifier.Operation.ADDITION, inst.m_22135_(), AttributesLib.getTooltipFlag());
            list.add(Component.m_237110_((String)"Current: %s", (Object[])new Object[]{valueComp.m_130940_(color)}).m_130940_(ChatFormatting.GRAY));
            MutableComponent baseVal = fAttr.toValueComponent(AttributeModifier.Operation.ADDITION, inst.m_22115_(), AttributesLib.getTooltipFlag());
            baseVal = Component.m_237110_((String)"attributeslib.gui.base", (Object[])new Object[]{baseVal});
            if (attr instanceof RangedAttribute) {
                RangedAttribute ra = (RangedAttribute)attr;
                Object min = fAttr.toValueComponent(AttributeModifier.Operation.ADDITION, ra.m_147361_(), AttributesLib.getTooltipFlag());
                min = Component.m_237110_((String)"attributeslib.gui.min", (Object[])new Object[]{min});
                MutableComponent max = fAttr.toValueComponent(AttributeModifier.Operation.ADDITION, ra.m_147362_(), AttributesLib.getTooltipFlag());
                max = Component.m_237110_((String)"attributeslib.gui.max", (Object[])new Object[]{max});
                list.add(Component.m_237110_((String)"%s \u2507 %s \u2507 %s", (Object[])new Object[]{baseVal, min, max}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add(baseVal.m_130940_(ChatFormatting.GRAY));
            }
            ArrayList<ClientTooltipComponent> finalTooltip = new ArrayList<ClientTooltipComponent>(list.size());
            for (Object txt : list) {
                this.addComp((Component)txt, finalTooltip);
            }
            if (inst.m_22122_().stream().anyMatch(modif -> modif.m_22218_() != 0.0)) {
                this.addComp(CommonComponents.f_237098_, finalTooltip);
                this.addComp((Component)Component.m_237115_((String)"attributeslib.gui.modifiers").m_130940_(ChatFormatting.GOLD), finalTooltip);
                HashMap modifiersToSources = new HashMap();
                for (ModifierSourceType modifierSourceType : ModifierSourceType.getTypes()) {
                    modifierSourceType.extract((LivingEntity)this.player, (modif, source) -> modifiersToSources.put(modif.m_22209_(), (ModifierSource<?>)source));
                }
                Component[] opValues = new Component[3];
                for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                    double threshold;
                    ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(inst.m_22104_(operation));
                    double opValue = modifiers.stream().mapToDouble(AttributeModifier::m_22218_).reduce(operation == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0 : 0.0, (res, elem) -> op == AttributeModifier.Operation.MULTIPLY_TOTAL ? res * (1.0 + elem) : res + elem);
                    modifiers.sort(ModifierSourceType.compareBySource(modifiersToSources));
                    for (AttributeModifier modif2 : modifiers) {
                        if (modif2.m_22218_() == 0.0) continue;
                        MutableComponent comp = fAttr.toComponent(modif2, AttributesLib.getTooltipFlag());
                        ModifierSource src = (ModifierSource)modifiersToSources.get(modif2.m_22209_());
                        finalTooltip.add(new AttributeModifierComponent(src, (FormattedText)comp, this.font, this.leftPos - 16));
                    }
                    color = ChatFormatting.GRAY;
                    double d = threshold = operation == AttributeModifier.Operation.MULTIPLY_TOTAL ? 1.0005 : 5.0E-4;
                    if (opValue > threshold) {
                        color = ChatFormatting.YELLOW;
                    } else if (opValue < -threshold) {
                        color = ChatFormatting.RED;
                    }
                    MutableComponent valueComp2 = fAttr.toValueComponent(operation, opValue, AttributesLib.getTooltipFlag()).m_130940_(color);
                    MutableComponent comp = Component.m_237110_((String)("attributeslib.gui." + operation.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{valueComp2}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                    opValues[operation.ordinal()] = comp;
                }
                if (AttributesLib.getTooltipFlag().m_7050_()) {
                    this.addComp(CommonComponents.f_237098_, finalTooltip);
                    for (Component component : opValues) {
                        this.addComp(component, finalTooltip);
                    }
                }
            }
            this.parent.renderTooltip(stack, List.of(), 0, 0, this.font);
            this.parent.m_169383_(stack, finalTooltip, this.leftPos - 16 - finalTooltip.stream().map(c -> c.m_142069_(this.font)).max(Integer::compare).get(), mouseY);
        }
    }

    private void addComp(Component comp, List<ClientTooltipComponent> finalTooltip) {
        if (comp == CommonComponents.f_237098_) {
            finalTooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)comp.m_7532_()));
        } else {
            for (FormattedText fTxt : this.font.m_92865_().m_92414_((FormattedText)comp, this.leftPos - 16, comp.m_7383_())) {
                finalTooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Language.m_128107_().m_5536_(fTxt)));
            }
        }
    }

    private void renderEntry(PoseStack stack, AttributeInstance inst, int x, int y, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        boolean hover = this.getHoveredSlot(mouseX, mouseY) == inst;
        this.m_93228_(stack, x, y, 142, hover ? 22 : 0, 100, 22);
        MutableComponent txt = Component.m_237115_((String)inst.m_22099_().m_22087_());
        int splitWidth = 60;
        List lines = this.font.m_92923_((FormattedText)txt, splitWidth);
        while (lines.size() > 2) {
            lines = this.font.m_92923_((FormattedText)txt, splitWidth += 10);
        }
        stack.m_85836_();
        float scale = 1.0f;
        int maxWidth = lines.stream().map(arg_0 -> ((Font)this.font).m_92724_(arg_0)).max(Integer::compareTo).get();
        if (maxWidth > 66) {
            scale = 66.0f / (float)maxWidth;
            stack.m_85841_(scale, scale, 1.0f);
        }
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            float width = (float)this.font.m_92724_(line) * scale;
            float lineX = ((float)(x + 1) + (68.0f - width) / 2.0f) / scale;
            float lineY = (float)(y + (lines.size() == 1 ? 7 : 2) + i * 10) / scale;
            this.font.m_92877_(stack, line, lineX, lineY, 0x404040);
        }
        stack.m_85849_();
        stack.m_85836_();
        IFormattableAttribute attr = (IFormattableAttribute)inst.m_22099_();
        MutableComponent value = attr.toValueComponent(AttributeModifier.Operation.ADDITION, inst.m_22135_(), (TooltipFlag)TooltipFlag.Default.NORMAL);
        scale = 1.0f;
        if (this.font.m_92852_((FormattedText)value) > 27) {
            scale = 27.0f / (float)this.font.m_92852_((FormattedText)value);
            stack.m_85841_(scale, scale, 1.0f);
        }
        int color = 0xFFFFFF;
        if (attr instanceof RangedAttribute) {
            RangedAttribute ra = (RangedAttribute)attr;
            if (inst.m_22135_() > inst.m_22115_()) {
                color = 0x55DD55;
            } else if (inst.m_22135_() < inst.m_22115_()) {
                color = 0xFF6060;
            }
        }
        this.font.m_92763_(stack, (Component)value, ((float)(x + 72) + (27.0f - (float)this.font.m_92852_((FormattedText)value) * scale) / 2.0f) / scale, (float)(y + 7) / scale, color);
        stack.m_85849_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.open || !this.isScrollBarActive()) {
            return false;
        }
        this.scrolling = false;
        int left = this.leftPos + 111;
        int top = this.topPos + 15;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 155)) {
            this.scrolling = true;
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.m_14036_((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.open) {
            return false;
        }
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 15;
            int j = i + 138;
            scrollOffset = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            scrollOffset = Mth.m_14036_((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)this.getOffScreenRows()) + 0.5);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.open) {
            return false;
        }
        if (this.isScrollBarActive()) {
            int i = this.getOffScreenRows();
            scrollOffset = (float)((double)scrollOffset - pDelta / (double)i);
            scrollOffset = Mth.m_14036_((float)scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(scrollOffset * (float)i) + 0.5);
            return true;
        }
        return false;
    }

    public boolean m_5755_(boolean pFocus) {
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 6;
    }

    protected int getOffScreenRows() {
        return Math.max(0, this.data.size() - 6);
    }

    @Nullable
    public AttributeInstance getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 6; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.isHovering(8, 14 + 22 * i, 100, 22, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && (pMouseY -= (double)j) >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    public class HideUnchangedButton
    extends ImageButton {
        public HideUnchangedButton(int pX, int pY) {
            super(pX, pY, 10, 10, 131, 20, 10, TEXTURES, 256, 256, null, (Component)Component.m_237113_((String)"Hide Unchanged Attributes"));
            this.f_93624_ = false;
        }

        public void m_5691_() {
            hideUnchanged = !hideUnchanged;
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int vOffset;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
            int u = 131;
            int v = 20;
            int n = vOffset = hideUnchanged ? 0 : 10;
            if (this.f_93622_) {
                vOffset += 20;
            }
            RenderSystem.m_69482_();
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 0.0, 100.0);
            HideUnchangedButton.m_93133_((PoseStack)pPoseStack, (int)this.f_93620_, (int)this.f_93621_, (float)u, (float)(v + vOffset), (int)10, (int)10, (int)256, (int)256);
            pPoseStack.m_85849_();
        }
    }
}

