/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.boss.BossSpawnerBlock;

public class BossDungeonFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState CAVE_AIR = Blocks.f_50627_.m_49966_();
    private static final BlockState BRICK = Blocks.f_50222_.m_49966_();
    private static final BlockState MOSSY_BRICK = Blocks.f_50223_.m_49966_();
    private static final BlockState CRACKED_BRICK = Blocks.f_50224_.m_49966_();
    private static final BlockState[] BRICKS = new BlockState[]{BRICK, MOSSY_BRICK, CRACKED_BRICK};
    public static final BossDungeonFeature INSTANCE = new BossDungeonFeature();

    public BossDungeonFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockState state;
        BlockPos blockpos;
        int z;
        int y;
        int x;
        WorldGenLevel world = ctx.m_159774_();
        if (!AdventureConfig.canGenerateIn(world)) {
            return false;
        }
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        int xRadius = 3 + rand.m_188503_(3);
        int floor = -1;
        int roof = 4;
        int zRadius = 3 + rand.m_188503_(3);
        int doors = 0;
        BlockState[][][] states = new BlockState[xRadius * 2 + 1][6][zRadius * 2 + 1];
        for (x = -xRadius; x <= xRadius; ++x) {
            for (y = floor; y <= roof; ++y) {
                for (z = -zRadius; z <= zRadius; ++z) {
                    blockpos = pos.m_7918_(x, y, z);
                    state = world.m_8055_(blockpos);
                    Material material = state.m_60767_();
                    boolean flag = material.m_76333_();
                    if (y == floor && !flag || y == roof && !flag) {
                        return false;
                    }
                    if ((x == -xRadius || x == xRadius || z == -zRadius || z == zRadius) && y == 1 && state.m_60795_() && states[x + xRadius][y - 1 + 1][z + zRadius].m_60795_()) {
                        ++doors;
                    }
                    states[x + xRadius][y + 1][z + zRadius] = state;
                }
            }
        }
        if (doors >= 1 && doors <= 5) {
            for (x = -xRadius; x <= xRadius; ++x) {
                for (y = roof - 1; y >= floor; --y) {
                    for (z = -zRadius; z <= zRadius; ++z) {
                        blockpos = pos.m_7918_(x, y, z);
                        state = states[x + xRadius][y + 1][z + zRadius];
                        if (x != -xRadius && y != floor && z != -zRadius && x != xRadius && y != roof && z != zRadius) {
                            if (state.m_60713_(Blocks.f_50087_)) continue;
                            world.m_7731_(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (y > floor && !states[x + xRadius][y - 1 + 1][z + zRadius].m_60767_().m_76333_()) {
                            world.m_7731_(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (!state.m_60767_().m_76333_() || state.m_60713_(Blocks.f_50087_)) continue;
                        if (y == floor) {
                            world.m_7731_(blockpos, BRICKS[rand.m_188503_(3)], 2);
                            continue;
                        }
                        world.m_7731_(blockpos, rand.m_188499_() ? BRICK : BRICKS[rand.m_188503_(3)], 2);
                    }
                }
            }
            int xChestRadius = xRadius - 1;
            int zChestRadius = zRadius - 1;
            block6: for (int chests = 0; chests < 2; ++chests) {
                for (int attempts = 0; attempts < 3; ++attempts) {
                    boolean wall = rand.m_188499_();
                    int x2 = wall ? (rand.m_188499_() ? -xChestRadius : xChestRadius) : rand.m_188503_(xChestRadius * 2 + 1) - xChestRadius;
                    int y2 = 0;
                    int z2 = !wall ? (rand.m_188499_() ? -zChestRadius : zChestRadius) : rand.m_188503_(zChestRadius * 2 + 1) - zChestRadius;
                    BlockPos blockpos2 = pos.m_7918_(x2, y2, z2);
                    if (!world.m_8055_(blockpos2).m_60795_()) continue;
                    int nearbySolids = 0;
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        if (!world.m_8055_(blockpos2.m_121945_(dir)).m_60767_().m_76333_()) continue;
                        ++nearbySolids;
                    }
                    if (nearbySolids != true) continue;
                    world.m_7731_(blockpos2, StructurePiece.m_73407_((BlockGetter)world, (BlockPos)blockpos2, (BlockState)Blocks.f_50087_.m_49966_()), 2);
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)blockpos2, (ResourceLocation)BuiltInLootTables.f_78742_);
                    continue block6;
                }
            }
            world.m_7731_(pos, ((BossSpawnerBlock)((Object)Apoth.Blocks.BOSS_SPAWNER.get())).m_49966_(), 2);
            AdventureModule.debugLog(pos, "Boss Dungeon");
            return true;
        }
        return false;
    }
}

