/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.reforging.ReforgingScreen;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTileRenderer;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingScreen;
import shadows.apotheosis.adventure.client.AdventureKeys;
import shadows.apotheosis.adventure.client.BossSpawnMessage;
import shadows.apotheosis.adventure.client.FItemLayerModel;
import shadows.apotheosis.adventure.client.GemModel;
import shadows.apotheosis.adventure.client.SocketTooltipRenderer;
import shadows.apotheosis.core.attributeslib.api.AddAttributeTooltipsEvent;
import shadows.apotheosis.core.attributeslib.api.GatherSkippedAttributeTooltipsEvent;

public class AdventureModuleClient {
    public static List<BossSpawnMessage.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnMessage.BossSpawnData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AdventureModuleClient.class);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.REFORGING.get()), ReforgingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.SALVAGE.get()), SalvagingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Apoth.Menus.GEM_CUTTING.get()), GemCuttingScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Apoth.Tiles.REFORGING_TABLE.get()), k -> new ReforgingTableTileRenderer());
        MinecraftForge.EVENT_BUS.register(AdventureKeys.class);
    }

    public static void onBossSpawn(BlockPos pos, float[] color) {
        BOSS_SPAWNS.add(new BossSpawnMessage.BossSpawnData(pos, color, new MutableInt()));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_11860_, SoundSource.HOSTILE, AdventureConfig.bossAnnounceVolume, 1.25f, Minecraft.m_91087_().f_91074_.f_19796_, Minecraft.m_91087_().f_91074_.m_20183_()));
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        PoseStack stack = e.getPoseStack();
        MultiBufferSource.BufferSource buf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            stack.m_85836_();
            float partials = e.getPartialTick();
            Vec3 vec = Minecraft.m_91087_().m_91288_().m_20299_(partials);
            stack.m_85837_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            stack.m_85837_((double)data.pos().m_123341_(), (double)data.pos().m_123342_(), (double)data.pos().m_123343_());
            BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buf, (ResourceLocation)BeaconRenderer.f_112102_, (float)partials, (float)1.0f, (long)p.f_19853_.m_46467_(), (int)0, (int)64, (float[])data.color(), (float)0.166f, (float)0.33f);
            stack.m_85849_();
        }
        buf.m_109911_();
    }

    @SubscribeEvent
    public static void time(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            if (data.ticks().getAndIncrement() <= 400) continue;
            BOSS_SPAWNS.remove(i--);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void tooltips(AddAttributeTooltipsEvent e) {
        ItemStack stack = e.getStack();
        ListIterator<Component> it = e.getAttributeTooltipIterator();
        int sockets = SocketHelper.getSockets(stack);
        if (sockets > 0) {
            it.add((Component)Component.m_237113_((String)"APOTH_REMOVE_MARKER"));
        }
    }

    @SubscribeEvent
    public static void ignoreSocketUUIDS(GatherSkippedAttributeTooltipsEvent e) {
        ItemStack stack = e.getStack();
        for (ItemStack gem : SocketHelper.getGems(stack)) {
            GemItem.getUUIDs(gem).forEach(e::skipUUID);
        }
    }

    @SubscribeEvent
    public static void comps(RenderTooltipEvent.GatherComponents e) {
        int sockets = SocketHelper.getSockets(e.getItemStack());
        if (sockets == 0) {
            return;
        }
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            LiteralContents tc;
            Component comp;
            Object object;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((object = o.get()) instanceof Component) || !((object = (comp = (Component)object).m_214077_()) instanceof LiteralContents) || !"APOTH_REMOVE_MARKER".equals((tc = (LiteralContents)object).f_237368_())) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SocketTooltipRenderer.SocketComponent(e.getItemStack(), SocketHelper.getGems(e.getItemStack()))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void affixTooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            ArrayList components = new ArrayList();
            Consumer<Component> dotPrefixer = afxComp -> components.add(Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{afxComp}).m_130940_(ChatFormatting.YELLOW));
            affixes.values().stream().sorted(Comparator.comparingInt(a -> a.affix().getType().ordinal())).forEach(inst -> inst.addInformation(dotPrefixer));
            e.getToolTip().addAll(1, components);
        }
    }

    public static RenderType gray(ResourceLocation texture) {
        return CustomRenderTypes.GRAY.apply(texture);
    }

    public static void checkAffixLangKeys() {
        StringBuilder sb = new StringBuilder("Missing Affix Lang Keys:\n");
        boolean any = false;
        String json = "\"%s\": \"\",";
        for (Affix a : AffixManager.INSTANCE.getValues()) {
            if (!I18n.m_118936_((String)("affix." + a.getId()))) {
                sb.append(json.formatted("affix." + a.getId()) + "\n");
                any = true;
            }
            if (I18n.m_118936_((String)("affix." + a.getId() + ".suffix"))) continue;
            sb.append(json.formatted("affix." + a.getId() + ".suffix") + "\n");
            any = true;
        }
        if (any) {
            AdventureModule.LOGGER.error(sb.toString());
        }
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static ShaderInstance grayShader;
        private static final RenderStateShard.ShaderStateShard RENDER_TYPE_GRAY;
        public static Function<ResourceLocation, RenderType> GRAY;

        private static RenderType gray(ResourceLocation loc) {
            RenderType.CompositeState rendertype$state = RenderType.CompositeState.m_110628_().m_173292_(RENDER_TYPE_GRAY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(loc, false, false)).m_110685_(f_110139_).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(RenderStateShard.f_110114_).m_110691_(true);
            return CustomRenderTypes.m_173215_((String)"gray", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)rendertype$state);
        }

        private CustomRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
            throw new IllegalStateException("This class is not meant to be constructed!");
        }

        static {
            RENDER_TYPE_GRAY = new RenderStateShard.ShaderStateShard(() -> grayShader);
            GRAY = Util.m_143827_(CustomRenderTypes::gray);
        }
    }

    @Mod.EventBusSubscriber(modid="apotheosis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusSub {
        @SubscribeEvent
        public static void models(ModelEvent.RegisterAdditional e) {
            e.register(new ResourceLocation("apotheosis", "item/hammer"));
        }

        @SubscribeEvent
        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders e) {
            e.register("item_layers", (IGeometryLoader)FItemLayerModel.Loader.INSTANCE);
        }

        @SubscribeEvent
        public static void tooltipComps(RegisterClientTooltipComponentFactoriesEvent e) {
            e.register(SocketTooltipRenderer.SocketComponent.class, SocketTooltipRenderer::new);
        }

        @SubscribeEvent
        public static void addGemModels(ModelEvent.RegisterAdditional e) {
            Set locs = Minecraft.m_91087_().m_91098_().m_214159_("models", loc -> "apotheosis".equals(loc.m_135827_()) && loc.m_135815_().contains("/gems/") && loc.m_135815_().endsWith(".json")).keySet();
            for (ResourceLocation s : locs) {
                String path = s.m_135815_().substring("models/".length(), s.m_135815_().length() - ".json".length());
                e.register(new ResourceLocation("apotheosis", path));
            }
        }

        @SubscribeEvent
        public static void replaceGemModel(ModelEvent.BakingCompleted e) {
            ModelResourceLocation key = new ModelResourceLocation(Apotheosis.loc("gem"), "inventory");
            BakedModel oldModel = (BakedModel)e.getModels().get(key);
            if (oldModel != null) {
                e.getModels().put(key, new GemModel(oldModel, e.getModelBakery()));
            }
        }

        @SubscribeEvent
        public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("apotheosis:gray"), DefaultVertexFormat.f_85812_), shaderInstance -> {
                CustomRenderTypes.grayShader = shaderInstance;
            });
        }

        @SubscribeEvent
        public static void keys(RegisterKeyMappingsEvent e) {
            e.register(AdventureKeys.TOGGLE_RADIAL);
        }
    }
}

