/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesToastGui;
import com.anthonyhilyard.advancementplaques.Loader;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class AdvancementPlaque {
    private final AdvancementToast toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private Minecraft mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(AdvancementToast toastIn, Minecraft mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public AdvancementToast getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = Mth.m_14036_((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
    }

    private Toast.Visibility drawPlaque(PoseStack poseStack, long displayTime) {
        DisplayInfo displayInfo = this.toast.f_94795_.m_138320_();
        if (displayInfo != null) {
            float alpha;
            float fadeOutTime;
            float fadeInTime;
            float duration = switch (displayInfo.m_14992_()) {
                default -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskDuration.get() * 1000.0);
                }
                case FrameType.GOAL -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalDuration.get() * 1000.0);
                }
                case FrameType.CHALLENGE -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeDuration.get() * 1000.0);
                }
            };
            if ((float)displayTime >= fadeInTime) {
                alpha = 1.0f;
                if ((float)displayTime > duration) {
                    alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                }
                int tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.titleColor.get()).longValue();
                int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int titleColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.nameColor.get()).longValue();
                tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int nameColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUES);
                int frameOffset = 0;
                if (displayInfo.m_14992_() == FrameType.GOAL) {
                    frameOffset = 1;
                } else if (displayInfo.m_14992_() == FrameType.CHALLENGE) {
                    frameOffset = 2;
                }
                AdvancementPlaquesToastGui.m_93133_((PoseStack)poseStack, (int)-1, (int)-1, (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                if (alpha > 0.1f) {
                    int typeWidth = this.mc.f_91062_.m_92852_((FormattedText)displayInfo.m_14992_().m_15553_());
                    this.mc.f_91062_.m_92889_(poseStack, displayInfo.m_14992_().m_15553_(), (float)(this.width() - typeWidth) / 2.0f + 15.0f, 5.0f, titleColor);
                    int titleWidth = this.mc.f_91062_.m_92852_((FormattedText)displayInfo.m_14977_());
                    if ((float)titleWidth <= 146.66667f) {
                        PoseStack modelViewStack = RenderSystem.m_157191_();
                        modelViewStack.m_85836_();
                        modelViewStack.m_85841_(1.5f, 1.5f, 1.0f);
                        RenderSystem.m_157182_();
                        this.mc.f_91062_.m_92877_(poseStack, Language.m_128107_().m_5536_((FormattedText)displayInfo.m_14977_()), ((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f, 9.0f, nameColor);
                        modelViewStack.m_85849_();
                        RenderSystem.m_157182_();
                    } else {
                        this.mc.f_91062_.m_92877_(poseStack, Language.m_128107_().m_5536_((FormattedText)displayInfo.m_14977_()), (float)(this.width() - titleWidth) / 2.0f + 15.0f, 15.0f, nameColor);
                    }
                }
                PoseStack modelViewStack = RenderSystem.m_157191_();
                modelViewStack.m_85836_();
                modelViewStack.m_85837_(1.0, 1.0, 0.0);
                modelViewStack.m_85841_(1.5f, 1.5f, 1.0f);
                RenderSystem.m_157182_();
                this.itemRenderer.renderItemModelIntoGUIWithAlpha(displayInfo.m_14990_(), 1, 1, alpha);
                modelViewStack.m_85849_();
                RenderSystem.m_157182_();
                if (!this.hasPlayedSound) {
                    this.hasPlayedSound = true;
                    try {
                        switch (displayInfo.m_14992_()) {
                            case TASK: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteTasks.get()).booleanValue()) {
                                    this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)AdvancementPlaques.TASK_COMPLETE.get()), (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            case GOAL: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteGoals.get()).booleanValue()) {
                                    this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)AdvancementPlaques.GOAL_COMPLETE.get()), (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            default: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteChallenges.get()).booleanValue()) {
                                    this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12496_, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        Loader.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered! Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                    }
                }
            }
            if ((float)displayTime < fadeInTime + fadeOutTime) {
                alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                if ((float)displayTime < fadeInTime) {
                    alpha = (float)displayTime / fadeInTime;
                }
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 95.0);
                RenderSystem.m_157456_((int)0, (ResourceLocation)AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                if (displayInfo.m_14992_() == FrameType.CHALLENGE) {
                    AdvancementPlaquesToastGui.m_93133_((PoseStack)poseStack, (int)-16, (int)-16, (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                } else {
                    AdvancementPlaquesToastGui.m_93133_((PoseStack)poseStack, (int)-16, (int)-16, (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                }
                poseStack.m_85849_();
            }
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }

    public boolean render(int screenWidth, int index, PoseStack poseStack) {
        long currentTime = Util.m_137550_();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
            this.visibility.m_94909_(this.mc.m_91106_());
        }
        if (this.visibility == Toast.Visibility.SHOW && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.m_69465_();
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        if (((Boolean)AdvancementPlaquesConfig.INSTANCE.onTop.get()).booleanValue()) {
            modelViewStack.m_85837_((double)((float)(this.mc.m_91268_().m_85445_() - this.width()) / 2.0f), (double)((Integer)AdvancementPlaquesConfig.INSTANCE.distance.get()).intValue(), (double)(900.0f + (float)index));
        } else {
            modelViewStack.m_85837_((double)((float)(this.mc.m_91268_().m_85445_() - this.width()) / 2.0f), (double)(this.mc.m_91268_().m_85446_() - (this.height() + (Integer)AdvancementPlaquesConfig.INSTANCE.distance.get())), (double)(900.0f + (float)index));
        }
        RenderSystem.m_157182_();
        Toast.Visibility newVisibility = this.drawPlaque(poseStack, currentTime - this.visibleTime);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == Toast.Visibility.HIDE && currentTime - this.animationTime > 200L;
    }
}

