/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.base;

import de.melanx.aiotbotania.AIOTBotania;
import de.melanx.aiotbotania.data.ModTags;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import de.melanx.aiotbotania.items.livingwood.ItemLivingwoodAIOT;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemAIOTBase
extends DiggerItem
implements CustomDamageItem {
    protected final int manaPerDamage;
    protected final boolean special;
    protected final Tier tier;

    public ItemAIOTBase(Tier tier, float attackDamage, float attackSpeed, int manaPerDamage, boolean special) {
        super(attackDamage, attackSpeed, tier, ModTags.Blocks.MINEABLE_WITH_AIOT, new Item.Properties().m_41491_(AIOTBotania.instance.getTab()));
        this.manaPerDamage = manaPerDamage;
        this.special = special;
        this.tier = tier;
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
    }

    public static String getModeString(ItemStack stack) {
        Item tool = stack.m_41720_();
        if (tool instanceof ItemLivingrockAIOT || tool instanceof ItemLivingwoodAIOT) {
            return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeMode" : ".utilityMode");
        }
        return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeModePath" : ".utilityMode");
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        ToolUtil.inventoryTick(stack, level, entity, this.manaPerDamage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, entity, (int)this.manaPerDamage);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)context.m_43722_(), (String)"hoemode", (boolean)true);
        InteractionResult result = InteractionResult.PASS;
        if (hoemode) {
            if (!player.m_6047_()) {
                result = ToolUtil.hoeUse(context, this.special, false);
            } else if (context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
                result = ToolUtil.shovelUse(context);
            }
            return result == InteractionResult.PASS ? ToolUtil.stripLog(context) : result;
        }
        if (!player.m_6047_()) {
            result = ToolUtil.pickUse(context);
        }
        if (result == InteractionResult.PASS && context.m_43719_() == Direction.UP) {
            result = ToolUtil.axeUse(context);
        }
        return result;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            ToolUtil.toggleMode(player, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public float m_8102_(@Nonnull ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_.m_7454_(Items.f_42388_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level level, List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)ItemAIOTBase.getModeString(stack)));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolUtil.DEFAULT_AIOT_ACTIONS.contains(toolAction);
    }
}

