/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.handler.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.aiotbotania.items.base.ItemShearsBase;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class GrassModifier
extends LootModifier {
    public static final Supplier<Codec<GrassModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> GrassModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, GrassModifier::new)));
    private static final Random RANDOM = new Random();

    public GrassModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (state != null && tool != null && state.m_60734_() instanceof TallGrassBlock && tool.m_41720_() instanceof ItemShearsBase && tool.getEnchantmentLevel(Enchantments.f_44985_) <= 0) {
            return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack(GrassModifier::getRandomSeed)});
        }
        return generatedLoot;
    }

    @Nonnull
    private static Item getRandomSeed() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Holder itemHolder : Registry.f_122827_.m_206058_(Tags.Items.SEEDS)) {
            items.add((Item)itemHolder.m_203334_());
        }
        return (Item)items.get(RANDOM.nextInt(items.size()));
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

