/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity.goals.eater;

import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.wanmine.wab.entity.Eater;
import net.wanmine.wab.init.world.WabEffects;
import net.wanmine.wab.init.world.WabSounds;

public class RoarFirstGoal
extends NearestAttackableTargetGoal<Player> {
    private final Eater entity;
    private int ticksLeft = 0;

    public RoarFirstGoal(Eater entity, Class<Player> player, boolean mustSee) {
        super((Mob)entity, player, mustSee);
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.reset();
            } else if (this.ticksLeft == 42) {
                this.entity.setState(Eater.State.ROAR);
            } else if (this.ticksLeft == 33) {
                if (this.entity.m_6162_()) {
                    this.entity.m_9236_().m_214150_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), (SoundEvent)WabSounds.BABY_EATER_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f, 0L);
                } else {
                    this.entity.m_9236_().m_214150_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), (SoundEvent)WabSounds.EATER_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f, 0L);
                }
                for (LivingEntity target : this.entity.m_9236_().m_45976_(LivingEntity.class, this.entity.m_20191_().m_82377_(16.0, 24.0, 16.0))) {
                    if (target instanceof Eater) continue;
                    if (target instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)target;
                        if (player.f_8941_.m_9290_() == GameType.CREATIVE) continue;
                    }
                    target.m_7292_(new MobEffectInstance((MobEffect)WabEffects.FEAR.get(), 140));
                }
            }
        }
    }

    private void reset() {
        this.ticksLeft = -1;
        this.entity.setState(Eater.State.IDLE);
    }

    public void m_8041_() {
        this.entity.applyFutureTarget();
        this.entity.setRoared(true);
    }

    public void m_8056_() {
        this.ticksLeft = 52;
        if (!this.entity.m_9236_().f_46443_ && this.entity.m_5448_() != null) {
            this.entity.m_21563_().m_24960_((Entity)this.entity.m_5448_(), 30.0f, 30.0f);
        }
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        if (!this.entity.m_6162_()) {
            Random random;
            if (this.entity.shouldRoar()) {
                return true;
            }
            if (super.m_8036_() && (random = new Random()).nextInt(99) == 0) {
                for (Eater eater : this.entity.m_9236_().m_45976_(Eater.class, this.entity.m_20191_().m_82377_(16.0, 8.0, 16.0))) {
                    if (!eater.m_6162_()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

