/*
 * Decompiled with CFR 0.152.
 */
package net.wanmine.wab.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.data.WabTags;
import net.wanmine.wab.init.world.WabItems;
import net.wanmine.wab.init.world.WabParticles;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Toxlacanth
extends AbstractFish
implements GeoEntity {
    public static final String ID = "toxlacanth";
    public static final String SPAWN_EGG_ID = "toxlacanth_spawn_egg";
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Toxlacanth.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation SWIM = RawAnimation.begin().thenPlay("move.swim");
    private static final RawAnimation GROUND_IDLE = RawAnimation.begin().thenPlay("misc.ground_idle");
    private static final RawAnimation TOXIC_GAS = RawAnimation.begin().thenPlay("attack.toxic_gas");
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int toxicGasTick = 0;

    public Toxlacanth(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 2;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public static boolean canSpawn(EntityType<? extends Toxlacanth> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        Holder biome = level.m_204166_(pos);
        if (pos.m_123342_() > 35 && !biome.m_203656_(WabTags.Biomes.TOXLACANTH_SPAWN)) {
            return false;
        }
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController[]{Toxlacanth.state(this)});
    }

    private static AnimationController<Toxlacanth> state(Toxlacanth toxlacanth) {
        return new AnimationController((GeoAnimatable)toxlacanth, "state", 1, state -> {
            if (toxlacanth.m_20072_()) {
                if (toxlacanth.toxicGasTick > 0) {
                    return state.setAndContinue(TOXIC_GAS);
                }
                return state.setAndContinue(SWIM);
            }
            return state.setAndContinue(GROUND_IDLE);
        });
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.toxicGasTick = this.f_20916_ == 9 ? 15 : Math.max(0, this.toxicGasTick - 1);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (super.m_6469_(pSource, pAmount) && this.m_21188_() != null) {
            if (pSource.m_7639_() != null && this.m_6084_()) {
                this.spawnVenom();
            }
            return true;
        }
        return false;
    }

    private void spawnVenom() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12441_, SoundSource.NEUTRAL, this.m_6121_(), this.m_6100_());
        Vec3 vec3 = this.rotateVector(new Vec3(0.0, 0.0, -1.0)).m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        for (int i = 0; i < 6; ++i) {
            Vec3 vec31 = this.rotateVector(new Vec3((double)this.f_19796_.m_188501_() * 0.6 - 0.3, 0.0, (double)this.f_19796_.m_188501_() * 0.6 - 0.3));
            Vec3 vec32 = vec31.m_82490_(1.0 + (double)(this.f_19796_.m_188501_() * 5.0f));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)WabParticles.TOXLACANTH_SMOKE.get()), vec3.f_82479_, vec3.f_82480_ + 0.5, vec3.f_82481_, 0, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (double)0.1f);
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)vec3, (double)3.0, (double)3.0, (double)3.0))) {
            if (entity instanceof Toxlacanth || entity instanceof Soarer) continue;
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 500), (Entity)this);
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 300), (Entity)this);
            entity.m_147207_(new MobEffectInstance(MobEffects.f_19604_, 200), (Entity)this);
        }
    }

    private Vec3 rotateVector(Vec3 pVector) {
        return pVector.m_82524_(-this.f_20884_ * ((float)Math.PI / 180));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)WabItems.TOXLACANTH_BUCKET.get());
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12329_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

