/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpectralBlinkActivationOverlay {
    private static final int TOTAL_FRAMES = 8;
    private static final long TOTAL_DURATION = 600L;
    private static final long FRAME_DURATION = 75L;
    private static final ResourceLocation[] FRAME_TEXTURES = new ResourceLocation[8];
    private static boolean isActive;
    private static long effectStartTime;

    public static void renderOverlay(GuiGraphics graphics, Player player, int screenWidth, int screenHeight) {
        if (!isActive || player == null) {
            return;
        }
        long elapsed = System.currentTimeMillis() - effectStartTime;
        if (elapsed >= 600L) {
            isActive = false;
            return;
        }
        int currentFrame = (int)(elapsed / 75L);
        currentFrame = Math.min(currentFrame, 7);
        SpectralBlinkActivationOverlay.renderFrame(graphics, currentFrame, screenWidth, screenHeight);
    }

    private static void renderFrame(GuiGraphics graphics, int frameIndex, int screenWidth, int screenHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280163_(FRAME_TEXTURES[frameIndex], 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.disableBlend();
    }

    public static void triggerEffect() {
        isActive = true;
        effectStartTime = System.currentTimeMillis();
    }

    public static boolean isActive() {
        return isActive;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            SpectralBlinkActivationOverlay.FRAME_TEXTURES[i] = new ResourceLocation("traveloptics", "textures/gui/spectral_blink_activation/spectral_activation_frame_" + String.format("%02d", i) + ".png");
        }
        isActive = false;
        effectStartTime = 0L;
    }
}

