/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="traveloptics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BossMessageOverlay {
    private static Component currentMessage = null;
    private static int backgroundColor = Integer.MIN_VALUE;
    private static long messageStartTime = 0L;
    private static int messageDuration = 100;
    private static long lastRefreshTime = 0L;
    private static boolean shouldPlayIntroAnimation = false;
    public static float VERTICAL_POSITION_RATIO = 0.2f;
    private static final long INTRO_ANIMATION_DURATION = 400L;

    public static void displayMessage(Component message, int bgColor, int duration, boolean refresh, boolean forceIntroAnimation) {
        long currentTime = System.currentTimeMillis();
        boolean shouldShowIntro = false;
        if (forceIntroAnimation) {
            shouldShowIntro = true;
        } else if (currentMessage == null) {
            shouldShowIntro = true;
        } else {
            if (refresh && currentMessage.getString().equals(message.getString())) {
                lastRefreshTime = currentTime;
                return;
            }
            if (!currentMessage.getString().equals(message.getString())) {
                shouldShowIntro = true;
            }
        }
        currentMessage = message;
        backgroundColor = bgColor;
        messageDuration = duration;
        messageStartTime = currentTime;
        lastRefreshTime = currentTime;
        shouldPlayIntroAnimation = shouldShowIntro;
    }

    public static void displayMessage(Component message, int bgColor, int duration, boolean refresh) {
        BossMessageOverlay.displayMessage(message, bgColor, duration, refresh, false);
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        long durationMs;
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        if (currentMessage == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedSinceRefresh = currentTime - lastRefreshTime;
        if (elapsedSinceRefresh > (durationMs = (long)messageDuration * 50L)) {
            currentMessage = null;
            shouldPlayIntroAnimation = false;
            return;
        }
        double alpha = 1.0;
        long fadeStartTime = Math.max(durationMs - 1000L, (long)((double)durationMs * 0.8));
        if (elapsedSinceRefresh > fadeStartTime) {
            double fadeProgress = (double)(elapsedSinceRefresh - fadeStartTime) / (double)(durationMs - fadeStartTime);
            alpha = Math.max(0.0, 1.0 - fadeProgress);
        }
        if (alpha < 0.05) {
            currentMessage = null;
            shouldPlayIntroAnimation = false;
            return;
        }
        BossMessageOverlay.renderBossScreenMessage(event.getGuiGraphics(), mc, alpha, currentTime);
    }

    private static void renderBossScreenMessage(GuiGraphics guiGraphics, Minecraft mc, double alpha, long currentTime) {
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int messageY = (int)((float)screenHeight * VERTICAL_POSITION_RATIO);
        int textWidth = mc.f_91062_.m_92852_((FormattedText)currentMessage);
        Objects.requireNonNull(mc.f_91062_);
        int textHeight = 9;
        int bgWidth = Math.max(300, textWidth + 160);
        int bgHeight = textHeight + 16;
        int bgX = (screenWidth - bgWidth) / 2;
        int messageX = (screenWidth - textWidth) / 2;
        float animationScale = 1.0f;
        if (shouldPlayIntroAnimation) {
            long elapsedSinceStart = currentTime - messageStartTime;
            if (elapsedSinceStart < 400L) {
                float progress = (float)elapsedSinceStart / 400.0f;
                animationScale = BossMessageOverlay.easeOutBack(progress);
            } else {
                shouldPlayIntroAnimation = false;
                animationScale = 1.0f;
            }
        }
        int animatedBgWidth = (int)((float)bgWidth * animationScale);
        int animatedBgX = bgX + (bgWidth - animatedBgWidth) / 2;
        int finalBgColor = BossMessageOverlay.applyAlphaPrecise(backgroundColor, alpha);
        BossMessageOverlay.renderGradientBackground(guiGraphics, animatedBgX, messageY - 8, animatedBgWidth, bgHeight, finalBgColor);
        double textAlpha = alpha * Math.min(1.0, (double)animationScale);
        int textColor = BossMessageOverlay.applyAlphaPrecise(-1, textAlpha);
        boolean enableShadow = textAlpha > 0.3;
        guiGraphics.m_280614_(mc.f_91062_, currentMessage, messageX, messageY, textColor, enableShadow);
    }

    private static float easeOutBack(float t) {
        float c1 = 1.70158f;
        float c3 = 2.70158f;
        return 1.0f + 2.70158f * (float)Math.pow(t - 1.0f, 3.0) + 1.70158f * (float)Math.pow(t - 1.0f, 2.0);
    }

    private static void renderGradientBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int centerColor) {
        float verticalFade2;
        float verticalFade1;
        float y2;
        float y1;
        int j;
        float a2;
        float a1;
        float x2;
        float x1;
        int i;
        int alpha = centerColor >> 24 & 0xFF;
        int red = centerColor >> 16 & 0xFF;
        int green = centerColor >> 8 & 0xFF;
        int blue = centerColor & 0xFF;
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float baseAlpha = (float)alpha / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int segments = 16;
        int topEdgePixels = 5;
        int bottomEdgePixels = 5;
        float[] positions = new float[segments + 1];
        float[] alphas = new float[segments + 1];
        for (i = 0; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            positions[i] = (float)x + t * (float)width;
            float distanceFromCenter = Math.abs(t - 0.5f) * 2.0f;
            float fadeAlpha = 1.0f - (float)((double)distanceFromCenter * Math.sqrt(distanceFromCenter));
            fadeAlpha = Math.max(0.0f, fadeAlpha);
            alphas[i] = baseAlpha * fadeAlpha;
        }
        for (i = 0; i < segments; ++i) {
            x1 = positions[i];
            x2 = positions[i + 1];
            a1 = alphas[i];
            a2 = alphas[i + 1];
            buffer.m_252986_(matrix, x1, (float)(y + 2), 0.0f).m_85950_(r, g, b, a1).m_5752_();
            buffer.m_252986_(matrix, x1, (float)(y + height - 2), 0.0f).m_85950_(r, g, b, a1).m_5752_();
            buffer.m_252986_(matrix, x2, (float)(y + height - 2), 0.0f).m_85950_(r, g, b, a2).m_5752_();
            buffer.m_252986_(matrix, x2, (float)(y + 2), 0.0f).m_85950_(r, g, b, a2).m_5752_();
        }
        for (i = 0; i < segments; ++i) {
            x1 = positions[i];
            x2 = positions[i + 1];
            a1 = alphas[i];
            a2 = alphas[i + 1];
            for (j = 0; j < topEdgePixels; ++j) {
                y1 = y + j;
                y2 = y + j + 1;
                verticalFade1 = (float)j / (float)topEdgePixels;
                verticalFade2 = (float)(j + 1) / (float)topEdgePixels;
                buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a1 * verticalFade1).m_5752_();
                buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a1 * verticalFade2).m_5752_();
                buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a2 * verticalFade2).m_5752_();
                buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a2 * verticalFade1).m_5752_();
            }
        }
        for (i = 0; i < segments; ++i) {
            x1 = positions[i];
            x2 = positions[i + 1];
            a1 = alphas[i];
            a2 = alphas[i + 1];
            for (j = 0; j < bottomEdgePixels; ++j) {
                y1 = y + height - bottomEdgePixels + j;
                y2 = y + height - bottomEdgePixels + j + 1;
                verticalFade1 = (float)(bottomEdgePixels - j) / (float)bottomEdgePixels;
                verticalFade2 = (float)(bottomEdgePixels - j - 1) / (float)bottomEdgePixels;
                buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a1 * verticalFade1).m_5752_();
                buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a1 * verticalFade2).m_5752_();
                buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a2 * verticalFade2).m_5752_();
                buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a2 * verticalFade1).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private static int applyAlphaPrecise(int color, double alpha) {
        int originalAlpha = color >> 24 & 0xFF;
        int newAlpha = (int)Math.round((double)originalAlpha * alpha);
        newAlpha = Math.max(0, Math.min(255, newAlpha));
        return newAlpha << 24 | color & 0xFFFFFF;
    }

    public static void setVerticalPosition(float ratio) {
        VERTICAL_POSITION_RATIO = Math.max(0.0f, Math.min(1.0f, ratio));
    }
}

