/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.utils;

import com.gametechbc.traveloptics.api.item.AbstractEchoCurio;
import com.gametechbc.traveloptics.api.item.AdvancedEchoCurio;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class TOCurioUtils {
    public static boolean getWearingCurio(LivingEntity entity, Item curioItem) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> !curios.findCurios(item -> item != null && item.m_150930_(curioItem)).isEmpty()).orElse(false);
    }

    public static boolean getEchoCurios(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> !curios.findCurios(item -> item != null && item.m_41720_() instanceof AbstractEchoCurio).isEmpty()).orElse(false);
    }

    public static boolean getAdvancedEchoCurios(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> !curios.findCurios(item -> item != null && item.m_41720_() instanceof AdvancedEchoCurio).isEmpty()).orElse(false);
    }

    public static Optional<ItemStack> getCurioFromSlot(LivingEntity entity, String slotType) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curiosItemHandler -> Optional.ofNullable((ICurioStacksHandler)curiosItemHandler.getCurios().get(slotType))).flatMap(stacksHandler -> {
            for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                return Optional.of(stack);
            }
            return Optional.empty();
        });
    }

    public static boolean isItemInCurioSlot(LivingEntity entity, Item item, String slotType) {
        return TOCurioUtils.getCurioFromSlot(entity, slotType).map(stack -> stack.m_41720_() == item).orElse(false);
    }

    public static Optional<ItemStack> getCurioFromSlotIndex(LivingEntity entity, String slotType, int slotIndex) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).resolve().flatMap(curiosItemHandler -> Optional.ofNullable((ICurioStacksHandler)curiosItemHandler.getCurios().get(slotType))).flatMap(stacksHandler -> {
            if (slotIndex >= 0 && slotIndex < stacksHandler.getStacks().getSlots()) {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(slotIndex);
                return !stack.m_41619_() ? Optional.of(stack) : Optional.empty();
            }
            return Optional.empty();
        });
    }

    public static boolean isItemInCurioSlotIndex(LivingEntity entity, Item item, String slotType, int slotIndex) {
        return TOCurioUtils.getCurioFromSlotIndex(entity, slotType, slotIndex).map(stack -> stack.m_41720_() == item).orElse(false);
    }

    public static void broadcastCurioBreakEvent(SlotContext slotContext) {
        CuriosApi.broadcastCurioBreakEvent((SlotContext)slotContext);
    }

    public static LazyOptional<ICurio> getCurio(ItemStack stack) {
        return CuriosApi.getCurio((ItemStack)stack);
    }
}

