/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncComponentsPacket {
    private final int entityID;
    private final CompoundTag map;

    public ClientboundSyncComponentsPacket(int entityID, CompoundTag map) {
        this.entityID = entityID;
        this.map = map;
    }

    public static ClientboundSyncComponentsPacket decode(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        CompoundTag map = buffer.m_130260_();
        return new ClientboundSyncComponentsPacket(entityID, map);
    }

    public static void encode(ClientboundSyncComponentsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.m_130079_(message.map);
    }

    public static void handle(ClientboundSyncComponentsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player playerEntity = (Player)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.entityID);
            ITravelersBackpack data = (ITravelersBackpack)CapabilityUtils.getCapability(playerEntity).orElseThrow(() -> new RuntimeException("No player attachment data found!"));
            if (data != null) {
                data.applyComponents(message.map);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

