/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.compat.comforts.ComfortsCompat;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.RecipeUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(ResourceLocation idIn, String groupIn, CraftingBookCategory category, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, boolean showNotification) {
        super(idIn, groupIn, category, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn, showNotification);
    }

    public ItemStack m_5874_(CraftingContainer pInput, RegistryAccess pRegistries) {
        ItemStack output = this.m_8043_(pRegistries).m_41777_();
        if (!output.m_41619_()) {
            boolean hasTanks = false;
            boolean customBackpack = false;
            for (int i = 0; i < pInput.m_6643_(); ++i) {
                ItemStack ingredient = pInput.m_8020_(i);
                if (ingredient.m_41720_() instanceof TravelersBackpackItem) {
                    output.m_41751_(ingredient.m_41784_());
                    customBackpack = true;
                    break;
                }
                if (ingredient.m_204117_(ModTags.SLEEPING_BAGS)) {
                    int color = ShapedBackpackRecipe.getProperColor(ingredient.m_41720_());
                    NbtHelper.set(output, "SleepingBagColor", color);
                }
                if (hasTanks || ingredient.m_41720_() != ModItems.BACKPACK_TANK.get()) continue;
                NbtHelper.set(output, "StarterUpgrades", List.of(((TanksUpgradeItem)((Object)ModItems.TANKS_UPGRADE.get())).m_7968_()));
                hasTanks = true;
            }
            if (!customBackpack) {
                NbtHelper.set(output, "StorageSlots", Tiers.LEATHER.getStorageSlots());
                if (hasTanks) {
                    NbtHelper.set(output, "RenderInfo", TanksUpgradeItem.writeToRenderData());
                } else {
                    NbtHelper.set(output, "RenderInfo", RenderInfo.EMPTY);
                }
            }
        }
        return output;
    }

    public static int getProperColor(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof SleepingBagBlock) {
            SleepingBagBlock sleepingBagBlock = (SleepingBagBlock)block;
            return sleepingBagBlock.m_49554_().m_41060_();
        }
        if (TravelersBackpack.comfortsLoaded) {
            return ComfortsCompat.getComfortsSleepingBagColor(item);
        }
        return DyeColor.RED.m_41060_();
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ShapedBackpackRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            RecipeUtils.ShapedPrimer primer = RecipeUtils.parseShaped(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            boolean flag = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedBackpackRecipe(recipeID, group, craftingbookcategory, primer.recipeWidth(), primer.recipeHeight(), primer.ingredients(), result, flag);
        }

        @Nullable
        public ShapedBackpackRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            boolean flag = buffer.readBoolean();
            return new ShapedBackpackRecipe(recipeID, group, craftingbookcategory, width, height, (NonNullList<Ingredient>)ingredients, result, flag);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedBackpackRecipe recipe) {
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.f_44149_, false);
            buffer.writeBoolean(recipe.m_271738_());
        }
    }
}

