/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;

public final class CMessagePlayerCapSyncAlignment {
    private final int alignment;

    public CMessagePlayerCapSyncAlignment(int alignment) {
        this.alignment = alignment;
    }

    static CMessagePlayerCapSyncAlignment fromBytes(FriendlyByteBuf buf) {
        return new CMessagePlayerCapSyncAlignment(buf.readShort());
    }

    static void toBytes(CMessagePlayerCapSyncAlignment msg, FriendlyByteBuf buf) {
        buf.writeShort(msg.alignment);
    }

    public static class Handler {
        static void handle(final CMessagePlayerCapSyncAlignment message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.setAlignment(message2.alignment));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

