/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class RVConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalZombieSpawnWeight;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalZombieSpawnMinCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalZombieSpawnMaxCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalSkeletonSpawnWeight;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalSkeletonSpawnMinCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalSkeletonSpawnMaxCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalCreeperSpawnWeight;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalCreeperSpawnMinCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalCreeperSpawnMaxCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalEndermanSpawnWeight;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalEndermanSpawnMinCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalEndermanSpawnMaxCount;
    public static final ForgeConfigSpec.ConfigValue<Integer> RoyalEndermanEndSpawnChance;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    static {
        BUILDER.push("Spawning");
        BUILDER.push("Royal Zombie");
        RoyalZombieSpawnWeight = BUILDER.comment("Spawn Weight for Royal Zombie, set to 0 to disable spawn, Default: 9").defineInRange("royalZombieSpawnWeight", 9, 0, Integer.MAX_VALUE);
        RoyalZombieSpawnMinCount = BUILDER.comment("Spawn minimum group count for Royal Zombie, Default: 1").defineInRange("royalZombieSpawnMinCount", 1, 1, Integer.MAX_VALUE);
        RoyalZombieSpawnMaxCount = BUILDER.comment("Spawn maximum group count for Royal Zombie, must be equal or higher than min count, Default: 1").defineInRange("royalZombieSpawnMaxCount", 1, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Royal Skeleton");
        RoyalSkeletonSpawnWeight = BUILDER.comment("Spawn Weight for Royal Skeleton, set to 0 to disable spawn, Default: 9").defineInRange("royalSkeletonSpawnWeight", 9, 0, Integer.MAX_VALUE);
        RoyalSkeletonSpawnMinCount = BUILDER.comment("Spawn minimum group count for Royal Skeleton, Default: 1").defineInRange("royalSkeletonSpawnMinCount", 1, 1, Integer.MAX_VALUE);
        RoyalSkeletonSpawnMaxCount = BUILDER.comment("Spawn maximum group count for Royal Skeleton, must be equal or higher than min count, Default: 1").defineInRange("royalSkeletonSpawnMaxCount", 1, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Royal Creeper");
        RoyalCreeperSpawnWeight = BUILDER.comment("Spawn Weight for Royal Creeper, set to 0 to disable spawn, Default: 9").defineInRange("royalCreeperSpawnWeight", 9, 0, Integer.MAX_VALUE);
        RoyalCreeperSpawnMinCount = BUILDER.comment("Spawn minimum group count for Royal Creeper, Default: 1").defineInRange("royalCreeperSpawnMinCount", 1, 1, Integer.MAX_VALUE);
        RoyalCreeperSpawnMaxCount = BUILDER.comment("Spawn maximum group count for Royal Creeper, must be equal or higher than min count, Default: 1").defineInRange("royalCreeperSpawnMaxCount", 1, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Royal Enderman");
        RoyalEndermanSpawnWeight = BUILDER.comment("Spawn Weight for Royal Enderman, set to 0 to disable spawn, Default: 5").defineInRange("royalEndermanSpawnWeight", 5, 0, Integer.MAX_VALUE);
        RoyalEndermanSpawnMinCount = BUILDER.comment("Spawn minimum group count for Royal Enderman, Default: 1").defineInRange("royalEndermanSpawnMinCount", 1, 1, Integer.MAX_VALUE);
        RoyalEndermanSpawnMaxCount = BUILDER.comment("Spawn maximum group count for Royal Enderman, must be equal or higher than min count, Default: 1").defineInRange("royalEndermanSpawnMaxCount", 1, 1, Integer.MAX_VALUE);
        RoyalEndermanEndSpawnChance = BUILDER.comment("Chance for Royal Enderman to spawn in The End, Default: 5").defineInRange("royalEndermanEndSpawnChance", 5, 0, 100);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

