/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.items.armor;

import com.mongoose.royalvariations.RoyalVariations;
import com.mongoose.royalvariations.client.render.RVModelLayer;
import com.mongoose.royalvariations.client.render.model.RoyalKnightBootsModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightCuirassModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightHelmetModel;
import com.mongoose.royalvariations.client.render.model.RoyalKnightLeggingsModel;
import com.mongoose.royalvariations.common.items.armor.RVArmorMaterials;
import com.mongoose.royalvariations.utils.ItemHelper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class RoyalKnightArmor
extends ArmorItem {
    public RoyalKnightArmor(ArmorItem.Type p_40387_) {
        super((ArmorMaterial)RVArmorMaterials.ROYAL_KNIGHT, p_40387_, new Item.Properties());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.HEAD) {
            return RoyalVariations.location("textures/models/armor/royal_knight_helmet.png").toString();
        }
        if (slot == EquipmentSlot.CHEST) {
            return RoyalVariations.location("textures/models/armor/royal_knight_cuirass.png").toString();
        }
        if (slot == EquipmentSlot.LEGS) {
            return RoyalVariations.location("textures/models/armor/royal_knight_leggings.png").toString();
        }
        if (slot == EquipmentSlot.FEET) {
            return RoyalVariations.location("textures/models/armor/royal_knight_boots.png").toString();
        }
        return RoyalVariations.location("textures/models/armor/royal_knight_armor.png").toString();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
                HumanoidModel model = equipmentSlot == EquipmentSlot.HEAD ? new RoyalKnightHelmetModel(modelSet.m_171103_(RVModelLayer.ROYAL_KNIGHT_HELMET)) : (equipmentSlot == EquipmentSlot.CHEST ? new RoyalKnightCuirassModel(modelSet.m_171103_(RVModelLayer.ROYAL_KNIGHT_CUIRASS)) : (equipmentSlot == EquipmentSlot.LEGS ? new RoyalKnightLeggingsModel(modelSet.m_171103_(RVModelLayer.ROYAL_KNIGHT_LEGGINGS)) : new RoyalKnightBootsModel(modelSet.m_171103_(RVModelLayer.ROYAL_KNIGHT_BOOTS))));
                model.f_102809_.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                model.f_102810_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.f_102811_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.f_102812_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                model.f_102813_.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.f_102814_.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                model.f_102610_ = original.f_102610_;
                model.f_102817_ = original.f_102817_;
                model.f_102609_ = original.f_102609_;
                model.f_102816_ = original.f_102816_;
                model.f_102815_ = original.f_102815_;
                return model;
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.royal_knight_armor.0"));
        tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.royal_knight_armor.1"));
    }
}

