/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.items;

import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.client.particles.RoyalGlowParticleOption;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.common.events.TimedEvents;
import com.mongoose.royalvariations.utils.EventTask;
import com.mongoose.royalvariations.utils.ItemHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SpiritualCrownItem
extends Item {
    public SpiritualCrownItem() {
        super(new Item.Properties());
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Level level;
        if (!RVCapHelper.isFlashing(target) && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (target.m_6084_()) {
                EntityType entityType = null;
                if (target instanceof Zombie) {
                    entityType = (EntityType)RVEntityType.ROYAL_ZOMBIE.get();
                } else if (target instanceof AbstractSkeleton) {
                    entityType = (EntityType)RVEntityType.ROYAL_SKELETON.get();
                } else if (target instanceof Creeper) {
                    entityType = (EntityType)RVEntityType.ROYAL_CREEPER.get();
                } else if (target instanceof EnderMan) {
                    entityType = (EntityType)RVEntityType.ROYAL_ENDERMAN.get();
                }
                if (entityType != null) {
                    TimedEvents.submitTask("royalvariations:convert", new ConversionTask(target.m_20148_(), serverLevel, (EntityType<? extends Mob>)entityType));
                    serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144051_, SoundSource.NEUTRAL, 0.9f, 1.0f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10592_.m_23682_(serverPlayer, stack);
                    }
                    stack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(tooltip));
    }

    public void addInformationAfterShift(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.spiritual_crown"));
        tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.spiritual_crown_disclaimer"));
    }

    public static class ConversionTask
    implements EventTask {
        public UUID entity;
        public ServerLevel level;
        public EntityType<? extends Mob> convertTo;

        public ConversionTask(UUID entity, ServerLevel level, EntityType<? extends Mob> convertTo) {
            this.entity = entity;
            this.level = level;
            this.convertTo = convertTo;
        }

        @Override
        public void startTask() {
            Entity entity = this.level.m_8791_(this.entity);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                RVCapHelper.setFlashTick((LivingEntity)mob, 10);
            }
        }

        @Override
        public void tickTask() {
            Entity entity = this.level.m_8791_(this.entity);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21573_().m_26573_();
                mob.m_21566_().m_24988_(0.0f, 0.0f);
            }
        }

        @Override
        public boolean getAsBoolean() {
            boolean flag = this.convertTo == null;
            Entity entity = this.level.m_8791_(this.entity);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (!RVCapHelper.isFlashing((LivingEntity)mob)) {
                    flag = true;
                }
                if (flag) {
                    Mob converted = mob.m_21406_(this.convertTo, true);
                    this.level.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SPARKLE.get()), mob.m_20185_(), mob.m_20186_() + 1.5, mob.m_20189_(), 5, 0.4, 0.1, 0.4, 0.1);
                    for (int i = 0; i <= this.level.m_213780_().m_188503_(10) + 10; ++i) {
                        this.level.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.HOLY.get()), mob.m_20208_(1.5), mob.m_20187_(), mob.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                    }
                    this.level.m_8767_((ParticleOptions)new RoyalGlowParticleOption(1.0f, 1.0f, 1.0f, 1.25f, 2), mob.m_20185_(), mob.m_20186_() + ((double)mob.m_20206_() / 2.0 - 0.2), mob.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.level.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_144162_, SoundSource.NEUTRAL, 0.8f, 1.0f);
                    if (converted != null) {
                        converted.m_146922_(mob.m_146908_());
                        converted.m_5616_(mob.m_6080_());
                        converted.m_5618_(mob.m_146908_());
                        converted.m_146926_(mob.m_146909_());
                    }
                }
            } else {
                flag = true;
            }
            return flag;
        }
    }
}

