/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.items;

import com.mojang.serialization.DynamicOps;
import com.mongoose.royalvariations.RoyalVariations;
import com.mongoose.royalvariations.client.particles.EndSplashParticleOption;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.utils.ItemHelper;
import com.mongoose.royalvariations.utils.MathHelper;
import com.mongoose.royalvariations.utils.ServerParticleUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RoyalTelelocator
extends Item {
    public static final String TAG_POS = "Pos";
    public static final String TAG_DIMENSION = "Dimension";

    public RoyalTelelocator() {
        super(new Item.Properties().m_41495_((Item)RVItems.EMPTY_ROYAL_TELELOCATOR.get()).m_41487_(1));
    }

    public boolean m_5812_(ItemStack pStack) {
        return RoyalTelelocator.hasBlock(pStack);
    }

    public static boolean hasBlock(ItemStack p_40737_) {
        CompoundTag compoundtag = p_40737_.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_DIMENSION) || compoundtag.m_128441_(TAG_POS));
    }

    private static Optional<ResourceKey<Level>> getBlockDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getPosition(ItemStack itemStack) {
        if (itemStack.m_41619_() || itemStack.m_41783_() == null || !itemStack.m_41783_().m_128441_(TAG_POS) || !itemStack.m_41783_().m_128441_(TAG_DIMENSION)) {
            return null;
        }
        CompoundTag tag = itemStack.m_41784_();
        return RoyalTelelocator.getPosition(tag);
    }

    @Nullable
    public static GlobalPos getPosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_POS);
        boolean flag1 = p_220022_.m_128441_(TAG_DIMENSION);
        if (flag && flag1 && (optional = RoyalTelelocator.getBlockDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    @Nullable
    public static BlockPos getBlockPos(ItemStack itemStack) {
        GlobalPos globalPos = RoyalTelelocator.getPosition(itemStack);
        if (globalPos != null) {
            return globalPos.m_122646_();
        }
        return null;
    }

    public static boolean isSameDimension(LivingEntity livingEntity, ItemStack stack) {
        GlobalPos globalPos = RoyalTelelocator.getPosition(stack);
        return globalPos != null && globalPos.m_122640_() == livingEntity.m_9236_().m_46472_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack held;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockState = context.m_43725_().m_8055_(blockpos);
        if (player != null && !(held = player.m_21120_(hand)).m_41619_() && held.m_41720_() instanceof RoyalTelelocator && !RoyalTelelocator.hasBlock(held)) {
            player.m_6674_(hand);
            CompoundTag nbt = held.m_41784_();
            this.addBlockTags((ResourceKey<Level>)player.m_9236_().m_46472_(), blockpos, nbt);
            player.m_5496_(SoundEvents.f_12326_, 1.0f, 1.0f);
            player.m_9236_().m_7785_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_12326_, SoundSource.PLAYERS, 1.0f, 0.45f, false);
            held.m_41751_(nbt);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.blockBreakParticles((ParticleOptions)RVParticleTypes.END_POOF.get(), blockpos, blockState, serverLevel);
            }
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void addBlockTags(ResourceKey<Level> p_40733_, BlockPos p_40734_, CompoundTag p_40735_) {
        p_40735_.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)p_40734_));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, p_40733_).resultOrPartial(arg_0 -> ((Logger)RoyalVariations.LOGGER).error(arg_0)).ifPresent(p_40731_ -> p_40735_.m_128365_(TAG_DIMENSION, p_40731_));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (RoyalTelelocator.hasBlock(itemstack)) {
            if (RoyalTelelocator.isSameDimension((LivingEntity)playerIn, itemstack)) {
                playerIn.m_6672_(handIn);
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            playerIn.m_5661_((Component)Component.m_237115_((String)"info.royalvariations.telelocator.outDim"), true);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntity, ItemStack stack, int tick) {
        for (int i = 0; i < 2; ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, livingEntity.m_20208_(0.5), livingEntity.m_20187_() - 0.25, livingEntity.m_20262_(0.5), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0, -worldIn.f_46441_.m_188500_(), (worldIn.f_46441_.m_188500_() - 0.5) * 2.0);
        }
        super.m_5929_(worldIn, livingEntity, stack, tick);
    }

    public ItemStack m_5922_(ItemStack p_41348_, Level p_41349_, LivingEntity p_41350_) {
        GlobalPos globalPos;
        super.m_5922_(p_41348_, p_41349_, p_41350_);
        if (RoyalTelelocator.getPosition(p_41348_) != null && (globalPos = RoyalTelelocator.getPosition(p_41348_)) != null && globalPos.m_122640_() == p_41350_.m_9236_().m_46472_()) {
            Vec3 vec3 = globalPos.m_122646_().m_252807_();
            p_41350_.m_6021_(vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_);
            p_41349_.m_6263_(null, p_41350_.m_20185_(), p_41350_.m_20186_(), p_41350_.m_20189_(), (SoundEvent)SoundEvents.f_12377_.get(), p_41350_.m_5720_(), 1.0f, 1.0f);
            p_41349_.m_7785_(p_41350_.m_20185_(), p_41350_.m_20186_(), p_41350_.m_20189_(), (SoundEvent)SoundEvents.f_12377_.get(), p_41350_.m_5720_(), 1.0f, 1.0f, false);
            if (p_41349_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)p_41349_;
                for (int i = 0; i < 20; ++i) {
                    double d0 = p_41349_.m_213780_().m_188583_() * 0.02;
                    double d1 = p_41349_.m_213780_().m_188583_() * 0.02;
                    double d2 = p_41349_.m_213780_().m_188583_() * 0.02;
                    double d3 = 10.0;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.END_POOF.get()), p_41350_.m_20165_(1.0) - d0 * d3, p_41350_.m_20187_() - d1 * d3, p_41350_.m_20262_(1.0) - d2 * d3, 0, d0, d1, d2, 1.0);
                }
                serverLevel.m_8767_((ParticleOptions)new EndSplashParticleOption(4.0f, 2), p_41350_.m_20185_(), p_41350_.m_20186_() + 0.5, p_41350_.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            p_41348_.m_41774_(1);
            if (p_41348_.m_41619_()) {
                return new ItemStack((ItemLike)RVItems.EMPTY_ROYAL_TELELOCATOR.get());
            }
            if (p_41350_ instanceof Player) {
                Player player = (Player)p_41350_;
                if (!player.m_150110_().f_35937_) {
                    ItemStack itemstack = new ItemStack((ItemLike)RVItems.EMPTY_ROYAL_TELELOCATOR.get());
                    if (!player.m_150109_().m_36054_(itemstack)) {
                        player.m_36176_(itemstack, false);
                    }
                }
            }
        }
        return p_41348_;
    }

    public int m_8105_(ItemStack p_41454_) {
        return MathHelper.secondsToTicks(4);
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ItemHelper.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, tooltip));
    }

    public void addInformationAfterShift(ItemStack stack, List<Component> tooltip) {
        boolean flag = false;
        if (stack.m_41783_() != null) {
            if (RoyalTelelocator.hasBlock(stack)) {
                BlockPos blockPos = RoyalTelelocator.getBlockPos(stack);
                if (blockPos != null && RoyalTelelocator.getBlockDimension(stack.m_41783_()).isPresent()) {
                    tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.telelocator.active"));
                    tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.telelocator.Pos").m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"info.royalvariations.telelocator.PosNum", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()})));
                    tooltip.add((Component)Component.m_237110_((String)"info.royalvariations.telelocator.PosDim", (Object[])new Object[]{RoyalTelelocator.getBlockDimension(stack.m_41783_()).get().m_135782_().toString()}));
                }
            } else {
                flag = true;
            }
        } else {
            flag = true;
        }
        if (flag) {
            tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.telelocator"));
            tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.telelocator.0"));
            tooltip.add((Component)Component.m_237115_((String)"info.royalvariations.telelocator.1"));
        }
    }
}

