/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.events;

import com.mongoose.royalvariations.client.particles.DTParticleOption;
import com.mongoose.royalvariations.client.particles.MarkParticleOption;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.client.particles.RoyalExplosionParticleOption;
import com.mongoose.royalvariations.client.particles.RoyalGlowParticleOption;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.ai.ChosenVictimGoal;
import com.mongoose.royalvariations.common.entities.ai.GazeGoal;
import com.mongoose.royalvariations.common.entities.hostile.RoyalCreeper;
import com.mongoose.royalvariations.common.entities.neutral.RoyalEnderman;
import com.mongoose.royalvariations.common.entities.projectile.SpectralAnvil;
import com.mongoose.royalvariations.common.events.TimedEvents;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.common.items.armor.RVArmorMaterials;
import com.mongoose.royalvariations.common.network.RVNetwork;
import com.mongoose.royalvariations.common.network.server.SRemoveEffectPacket;
import com.mongoose.royalvariations.config.RVConfig;
import com.mongoose.royalvariations.utils.CuriosFinder;
import com.mongoose.royalvariations.utils.CustomExplosion;
import com.mongoose.royalvariations.utils.EventTask;
import com.mongoose.royalvariations.utils.ItemHelper;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="royalvariations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RVEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof LivingEntity && !world.m_5776_() && entity instanceof Mob) {
            OwnableEntity ownable;
            Mob mob = (Mob)entity;
            if (mob instanceof EnderMan) {
                EnderMan enderMan = (EnderMan)mob;
                enderMan.f_21346_.m_25352_(0, new GazeGoal<LivingEntity>(mob, LivingEntity.class));
            }
            if (!(mob.m_6336_() != MobType.f_21641_ || mob instanceof OwnableEntity && (ownable = (OwnableEntity)mob).m_269323_() != null)) {
                mob.f_21346_.m_25352_(0, new ChosenVictimGoal<LivingEntity>(mob, LivingEntity.class));
            }
        }
    }

    @SubscribeEvent
    public static void LivingEffects(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null && !livingEntity.m_9236_().f_46443_) {
            AbstractSkeleton skeleton;
            if (RVCapHelper.isFlashing(livingEntity)) {
                RVCapHelper.decreaseFlashTick(livingEntity);
            }
            if (livingEntity.m_21023_((MobEffect)RVEffects.MARKED.get())) {
                RVCapHelper.setMarkedTick(livingEntity, 5);
            } else if (RVCapHelper.isMarked(livingEntity)) {
                RVCapHelper.setMarkedTick(livingEntity, 0);
            }
            if (livingEntity.m_21023_((MobEffect)RVEffects.PRESSING_GAZE.get())) {
                RVCapHelper.setGazeTick(livingEntity, 5);
            } else if (RVCapHelper.isGazed(livingEntity)) {
                RVCapHelper.setGazeTick(livingEntity, 0);
            }
            if (livingEntity instanceof AbstractSkeleton && (skeleton = (AbstractSkeleton)livingEntity).m_5448_() != null && skeleton.m_5448_().m_21224_()) {
                skeleton.m_6710_(null);
            }
        }
    }

    @SubscribeEvent
    public static void LivingTargetEvent(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getOriginalTarget();
        if (attacker instanceof IronGolem && target instanceof RoyalCreeper) {
            event.setNewTarget(null);
        }
    }

    @SubscribeEvent
    public static void LivingAttackEffects(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (livingEntity != null && livingEntity.m_6084_() && EntitySelector.f_20406_.test(livingEntity)) {
            Player player;
            Object object;
            if (ItemHelper.armorSet(livingEntity, RVArmorMaterials.ROYAL_KNIGHT) && (double)livingEntity.m_21223_() <= (double)livingEntity.m_21233_() * 0.4 && !livingEntity.m_21023_((MobEffect)RVEffects.KNIGHTLY_FORTITUDE.get())) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)RVEffects.KNIGHTLY_FORTITUDE.get(), 400, 0));
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.AURA_OF_PROTECTION.get()), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)1.4f, livingEntity.m_20189_(), Mth.m_216271_((RandomSource)livingEntity.m_217043_(), (int)3, (int)6), 0.3, 0.35, 0.3, 0.1);
                }
                List list = level.m_45976_(Entity.class, new AABB(livingEntity.m_20182_(), livingEntity.m_20182_()).m_82400_(5.5));
                object = list.iterator();
                while (object.hasNext()) {
                    OwnableEntity ownable;
                    LivingEntity living;
                    Entity entity = (Entity)object.next();
                    if (!(entity instanceof LivingEntity) || !((living = (LivingEntity)entity) instanceof OwnableEntity) || (ownable = (OwnableEntity)living).m_269323_() != livingEntity || !(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    living.m_7292_(new MobEffectInstance((MobEffect)RVEffects.KNIGHTLY_FORTITUDE.get(), 400, 1));
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.AURA_OF_PROTECTION.get()), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), Mth.m_216271_((RandomSource)living.m_217043_(), (int)3, (int)5), 0.2, 0.3, 0.2, 0.1);
                }
                if (!level.m_5776_()) {
                    level.m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_11669_, SoundSource.NEUTRAL, 0.6f, 0.9f);
                } else {
                    level.m_7785_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11669_, SoundSource.NEUTRAL, 0.6f, 0.9f, false);
                }
            }
            if ((object = event.getSource().m_7639_()) instanceof Player && CuriosFinder.hasCurio((LivingEntity)(player = (Player)object), (Item)RVItems.SPECTRAL_GAUNTLET.get()) && !MobUtil.areAllies((Entity)player, (Entity)livingEntity) && !player.m_36335_().m_41519_((Item)RVItems.SPECTRAL_GAUNTLET.get()) && level.m_213780_().m_188501_() <= 0.15f) {
                SpectralAnvil anvil = new SpectralAnvil(level, (LivingEntity)player);
                float height = Math.max(player.m_20206_(), livingEntity.m_20206_());
                anvil.m_146884_(livingEntity.m_20182_().m_82520_(0.0, (double)(height + 1.0f), 0.0));
                if (level.m_7967_((Entity)anvil)) {
                    player.m_36335_().m_41524_((Item)RVItems.SPECTRAL_GAUNTLET.get(), 140);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity().m_21023_((MobEffect)RVEffects.HEAVINESS_OF_THE_END.get())) {
            event.setDamageMultiplier(event.getDamageMultiplier() + 0.2f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity().m_21023_((MobEffect)RVEffects.TRAPPED.get())) {
            event.getEntity().m_21195_((MobEffect)RVEffects.TRAPPED.get());
            RVNetwork.sendToALL(new SRemoveEffectPacket(event.getEntity().m_19879_(), MobEffect.m_19459_((MobEffect)((MobEffect)RVEffects.TRAPPED.get()))));
        }
    }

    @SubscribeEvent
    public static void DropEvents(LivingDropsEvent event) {
        if (event.getEntity() != null) {
            RoyalCreeper creeper;
            Entity chance2;
            Zombie zombie;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Zombie && (zombie = (Zombie)livingEntity).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)RVItems.ROYAL_KNIGHT_HELMET.get())) {
                float chance2 = 0.1f;
                chance2 += (float)event.getLootingLevel() / 100.0f;
                if (zombie.m_9236_().f_46441_.m_188501_() <= chance2) {
                    event.getDrops().add(ItemHelper.itemEntityDrop((LivingEntity)zombie, new ItemStack((ItemLike)RVItems.ROYAL_ARMOR_FRAGMENTS.get())));
                }
            }
            if ((chance2 = event.getSource().m_7639_()) instanceof RoyalCreeper && (creeper = (RoyalCreeper)chance2).canDropMobsSkull()) {
                LivingEntity livingEntity2 = event.getEntity();
                if (livingEntity2 instanceof Creeper) {
                    Creeper creeper1 = (Creeper)livingEntity2;
                    creeper.increaseDroppedSkulls();
                    creeper1.m_19998_((ItemLike)Items.f_42682_);
                } else {
                    livingEntity2 = event.getEntity();
                    if (livingEntity2 instanceof Skeleton) {
                        Skeleton skeleton = (Skeleton)livingEntity2;
                        creeper.increaseDroppedSkulls();
                        skeleton.m_19998_((ItemLike)Items.f_42678_);
                    } else {
                        livingEntity2 = event.getEntity();
                        if (livingEntity2 instanceof Zombie) {
                            Zombie zombie2 = (Zombie)livingEntity2;
                            creeper.increaseDroppedSkulls();
                            zombie2.m_19998_((ItemLike)Items.f_42681_);
                        } else {
                            livingEntity2 = event.getEntity();
                            if (livingEntity2 instanceof WitherSkeleton) {
                                WitherSkeleton skeleton = (WitherSkeleton)livingEntity2;
                                creeper.increaseDroppedSkulls();
                                skeleton.m_19998_((ItemLike)Items.f_42679_);
                            } else {
                                livingEntity2 = event.getEntity();
                                if (livingEntity2 instanceof Piglin) {
                                    Piglin piglin = (Piglin)livingEntity2;
                                    creeper.increaseDroppedSkulls();
                                    piglin.m_19998_((ItemLike)Items.f_260451_);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        if (event.getEntity().m_21023_((MobEffect)RVEffects.TRAPPED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof RoyalEnderman && event.getLevel().m_6018_().m_46472_() == Level.f_46430_ && (event.getSpawnType() == MobSpawnType.NATURAL || event.getSpawnType() == MobSpawnType.CHUNK_GENERATION) && event.getLevel().m_213780_().m_188501_() > (float)((Integer)RVConfig.RoyalEndermanEndSpawnChance.get()).intValue() * 0.01f) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public static void PotionApplyEvents(MobEffectEvent.Applicable event) {
        ServerLevel serverLevel;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance.m_19544_() == RVEffects.UNDEAD_RUSH.get() && livingEntity.m_6336_() != MobType.f_21641_) {
            event.setResult(Event.Result.DENY);
        }
        if (instance.m_19544_() == RVEffects.DAZED.get() && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.DAZED_STAR.get()), livingEntity.m_20185_(), livingEntity.m_20186_() + 1.6, livingEntity.m_20189_(), serverLevel.m_213780_().m_216332_(4, 6), 0.35, 0.2, 0.35, 0.2);
        }
        if (instance.m_19544_() == RVEffects.MARKED.get() && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (livingEntity.m_6084_() && !livingEntity.m_21023_((MobEffect)RVEffects.MARKED.get())) {
                serverLevel.m_8767_((ParticleOptions)new MarkParticleOption(livingEntity.m_19879_()), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                serverLevel.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11686_, livingEntity.m_5720_(), 1.0f, 0.8f);
            }
        }
        if (instance.m_19544_() == RVEffects.PRESSING_GAZE.get() && livingEntity.m_9236_() instanceof ServerLevel && livingEntity.m_6084_() && !livingEntity.m_21023_((MobEffect)RVEffects.PRESSING_GAZE.get())) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 80, 0, false, false));
        }
        if (instance.m_19544_() == RVEffects.TIME_BOMB.get() && (level = livingEntity.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (livingEntity.m_6084_() && !livingEntity.m_21023_((MobEffect)RVEffects.TIME_BOMB.get())) {
                serverLevel.m_8767_((ParticleOptions)new DTParticleOption(livingEntity.m_19879_()), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                TimedEvents.submitTask("royalvariations:time_bomb", new TimeBombTask(livingEntity.m_20148_(), serverLevel));
            }
        }
    }

    public static class TimeBombTask
    implements EventTask {
        public static int TIME = 83;
        public UUID entity;
        public ServerLevel level;
        public int tick;

        public TimeBombTask(UUID entity, ServerLevel level) {
            this.entity = entity;
            this.level = level;
        }

        @Override
        public void startTask() {
            this.tick = 0;
        }

        @Override
        public void tickTask() {
            ++this.tick;
            Entity entity = this.level.m_8791_(this.entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.tick == TIME - 10) {
                    RVCapHelper.setFlashTick(livingEntity, 10);
                }
            }
        }

        @Override
        public boolean getAsBoolean() {
            LivingEntity livingEntity;
            boolean flag = false;
            Entity entity = this.level.m_8791_(this.entity);
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)RVEffects.TIME_BOMB.get())) {
                if (this.tick >= TIME) {
                    flag = true;
                }
                if (flag) {
                    this.level.m_8767_((ParticleOptions)new RoyalExplosionParticleOption(3.0f), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() / 2.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.level.m_8767_((ParticleOptions)new RoyalGlowParticleOption(1.0f, 1.0f, 1.0f, 6.0f, 2), livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() / 2.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    this.level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11913_, livingEntity.m_5720_(), 4.0f, (1.0f + (this.level.m_213780_().m_188501_() - this.level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                    new CustomExplosion((Level)this.level, (Entity)livingEntity, this.level.m_269111_().m_269093_(null), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 6.0f, 9.0f){

                        @Override
                        public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                            if (EntitySelector.f_20406_.test(target) && !(target instanceof RoyalCreeper)) {
                                super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                                if (MobUtil.notMonsterOrAnimal(target) && target instanceof LivingEntity) {
                                    LivingEntity living = (LivingEntity)target;
                                    living.m_7292_(new MobEffectInstance((MobEffect)RVEffects.DAZED.get(), 260));
                                }
                            }
                        }
                    };
                    livingEntity.m_21195_((MobEffect)RVEffects.TIME_BOMB.get());
                }
            } else {
                flag = true;
            }
            return flag;
        }
    }
}

