/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.entities.hostile;

import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.entities.hostile.RoyalMonster;
import com.mongoose.royalvariations.common.entities.projectile.NetEntity;
import com.mongoose.royalvariations.common.entities.projectile.RoyalArrow;
import com.mongoose.royalvariations.utils.MathHelper;
import com.mongoose.royalvariations.utils.MobUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class RoyalSkeleton
extends RoyalMonster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RoyalSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String PREPARE = "prepare";
    public static String AGGRESSION = "aggression";
    public static String STAND_DOWN = "stand_down";
    private boolean isWalking;
    private int toIdleTick;
    public int toAggroTick;
    public int standDownTick;
    private int netCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState toIdleAnimationState = new AnimationState();
    public AnimationState aggressionAnimationState = new AnimationState();
    public AnimationState prepareAnimationState = new AnimationState();
    public AnimationState standDownAnimationState = new AnimationState();
    public AnimationState crownAnimationState = new AnimationState();

    public RoyalSkeleton(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new KnightingGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, new RoyalBowAttackGoal<RoyalSkeleton>(this, 1.25, 50, 20.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 12.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, PREPARE)) {
            return 1;
        }
        if (Objects.equals(animation, AGGRESSION)) {
            return 2;
        }
        if (Objects.equals(animation, STAND_DOWN)) {
            return 3;
        }
        return 0;
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.stopAllAnimation();
                    this.prepareAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimation();
                    this.aggressionAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimation();
                    this.standDownAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.prepareAnimationState);
        animationStates.add(this.aggressionAnimationState);
        animationStates.add(this.standDownAnimationState);
        return animationStates;
    }

    public boolean isCurrentAnimation(String string) {
        return this.getCurrentAnimation() == this.getAnimationState(string);
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof AbstractSkeleton) {
            return this.m_5647_() == null && p_32665_.m_5647_() == null;
        }
        return super.m_7307_(p_32665_);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        LivingEntity attacker;
        Entity entity;
        if (this.netCool <= 0 && (entity = damageSource.m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_20270_((Entity)this) <= 6.0f && !MobUtil.areAllies((Entity)this, (Entity)attacker) && EntitySelector.f_20406_.test(attacker)) {
            MobUtil.instaLook((Mob)this, (Entity)attacker);
            double power = 10.0;
            double deltaX = this.m_20185_() - attacker.m_20185_();
            double deltaY = this.m_20186_() - (attacker.m_20186_() + 1.5);
            double deltaZ = this.m_20189_() - attacker.m_20189_();
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            double x = deltaX / distance * power * 0.2;
            double y = -(deltaY / distance * power * 0.06);
            double z = deltaZ / distance * power * 0.2;
            this.m_5496_(SoundEvents.f_12316_, 2.0f, 0.75f);
            this.m_20334_(x, y > 0.0 ? y + 0.2 : 0.2, z);
            this.poof((Entity)this);
            NetEntity net = new NetEntity(this.m_9236_(), (LivingEntity)this, (Entity)attacker);
            net.setLifeSpan(50);
            net.m_216990_(SoundEvents.f_12087_);
            this.poof((Entity)this.m_5448_());
            this.m_9236_().m_7967_((Entity)net);
            this.netCool = 220;
        }
        return super.m_6469_(damageSource, damage);
    }

    public void poof(Entity entity) {
        Level level;
        if (entity != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                double d3 = 10.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20185_() - d0 * d3, entity.m_20187_() - d1 * d3, entity.m_20189_() - d2 * d3, 0, d0, d1, d2, 1.0);
            }
        }
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.f_267362_.m_267780_()) {
                if (this.isWalking) {
                    this.isWalking = false;
                    this.toIdleTick = MathHelper.secondsToTicks(0.5f);
                }
            } else {
                this.isWalking = true;
            }
            if (this.toIdleTick > 0) {
                --this.toIdleTick;
            }
            boolean flag = !this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE);
            this.toIdleAnimationState.m_246184_(this.toIdleTick > 0 && flag, this.f_19797_);
            this.idleAnimationState.m_246184_(this.toIdleTick <= 0 && flag, this.f_19797_);
            this.crownAnimationState.m_216982_(this.f_19797_);
        } else {
            if (this.toAggroTick > 0) {
                --this.toAggroTick;
            } else if (this.m_5912_()) {
                this.setAnimationState(AGGRESSION);
            }
            if (this.standDownTick > 0) {
                --this.standDownTick;
            } else if (this.isCurrentAnimation(STAND_DOWN)) {
                this.setAnimationState(IDLE);
            }
            if (this.netCool > 0) {
                --this.netCool;
            }
        }
    }

    public void m_6504_(LivingEntity p_32141_, float p_32142_) {
        RoyalArrow royalArrow = new RoyalArrow(this.m_9236_(), (LivingEntity)this);
        royalArrow.setMarking(true);
        double d0 = p_32141_.m_20185_() - this.m_20185_();
        double d1 = p_32141_.m_20227_(0.3333333333333333) - royalArrow.m_20186_();
        double d2 = p_32141_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        royalArrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)royalArrow);
        this.toAggroTick = MathHelper.secondsToTicks(2.5f);
        this.setAnimationState(PREPARE);
    }

    public boolean m_5886_(ProjectileWeaponItem p_32144_) {
        return true;
    }

    protected float m_6431_(Pose p_32154_, EntityDimensions p_32155_) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.6;
    }

    static class KnightingGoal
    extends Goal {
        public static int FLASH_TIME = 5;
        public RoyalSkeleton royal;
        public List<AbstractSkeleton> list = new ArrayList<AbstractSkeleton>();
        public int blessTick;

        public KnightingGoal(RoyalSkeleton skeleton) {
            this.royal = skeleton;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.royal.m_5448_() != null && this.royal.knightCool <= 0) {
                List list = this.royal.m_9236_().m_45976_(AbstractSkeleton.class, this.royal.m_20191_().m_82400_(14.0));
                list.removeIf(skeleton -> !skeleton.m_142582_((Entity)this.royal) && skeleton.m_21205_().m_41793_() && !skeleton.m_21205_().m_204117_(Tags.Items.TOOLS_BOWS) && MobUtil.areAllies((Entity)skeleton, (Entity)this.royal.m_5448_()));
                this.list = list;
                return !this.list.isEmpty();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.blessTick > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            this.blessTick = FLASH_TIME + 1;
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (!this.list.isEmpty()) {
                for (AbstractSkeleton skeleton : this.list) {
                    if (!skeleton.m_21205_().m_204117_(Tags.Items.TOOLS_BOWS) || skeleton.m_21205_().m_41793_()) continue;
                    RVCapHelper.setFlashTick((LivingEntity)skeleton, FLASH_TIME);
                }
            }
        }

        public void m_8037_() {
            super.m_8037_();
            --this.blessTick;
            this.royal.m_21573_().m_26573_();
            this.royal.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.royal.m_5448_() != null) {
                this.royal.m_21563_().m_24960_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
                this.royal.m_21391_((Entity)this.royal.m_5448_(), 100.0f, 100.0f);
            }
            if (this.blessTick == 1 && !this.list.isEmpty()) {
                for (AbstractSkeleton skeleton : this.list) {
                    Level level = this.royal.m_9236_();
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (skeleton.m_21205_().m_204117_(Tags.Items.TOOLS_BOWS) && !skeleton.m_21205_().m_41793_()) {
                        skeleton.m_21205_().m_41663_(Enchantments.f_44988_, 2);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.SPARKLE.get()), skeleton.m_20185_(), skeleton.m_20186_() + (double)skeleton.m_20206_(), skeleton.m_20189_(), serverLevel.m_213780_().m_216332_(5, 6), 0.2, 0.3, 0.2, 0.1);
                        skeleton.m_5496_(SoundEvents.f_144051_, 0.9f, 1.0f);
                        serverLevel.m_6263_(null, skeleton.m_20185_(), skeleton.m_20186_(), skeleton.m_20189_(), SoundEvents.f_144051_, SoundSource.HOSTILE, 0.9f, 1.0f);
                        for (int i = 0; i <= serverLevel.m_213780_().m_188503_(10) + 10; ++i) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)RVParticleTypes.HOLY.get()), skeleton.m_20208_(1.5), skeleton.m_20187_(), skeleton.m_20262_(1.5), 0, 0.0, 1.0, 0.0, 1.0);
                        }
                    }
                    skeleton.m_6710_(this.royal.m_5448_());
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.blessTick = 0;
            this.royal.knightCool = 300;
            this.list.clear();
        }
    }

    public static class RoyalBowAttackGoal<T extends RoyalSkeleton>
    extends Goal {
        private final T mob;
        private final double speedModifier;
        private int attackIntervalMin;
        private final float attackRadiusSqr;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public RoyalBowAttackGoal(T p_25792_, double p_25793_, int p_25794_, float p_25795_) {
            this.mob = p_25792_;
            this.speedModifier = p_25793_;
            this.attackIntervalMin = p_25794_;
            this.attackRadiusSqr = p_25795_ * p_25795_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
            ((RoyalSkeleton)((Object)this.mob)).toAggroTick = MathHelper.secondsToTicks(2.5f);
            ((RoyalSkeleton)((Object)this.mob)).setAnimationState(PREPARE);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = 0;
            ((RoyalSkeleton)((Object)this.mob)).standDownTick = MathHelper.secondsToTicks(2);
            ((RoyalSkeleton)((Object)this.mob)).setAnimationState(STAND_DOWN);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    Entity entity = this.mob.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob1 = (Mob)entity;
                        mob1.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                    }
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (flag) {
                    ++this.attackTime;
                    if (this.attackTime >= this.attackIntervalMin && !((RoyalSkeleton)((Object)this.mob)).isCurrentAnimation(PREPARE)) {
                        ((RoyalSkeleton)((Object)this.mob)).m_6504_(livingentity, 1.0f);
                        this.attackTime = 0;
                    }
                }
            }
        }
    }
}

