/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.common.capabilities.misc;

import com.mongoose.royalvariations.RoyalVariations;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapHelper;
import com.mongoose.royalvariations.common.capabilities.misc.RVCapProvider;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RVCapUpdatePacket {
    private final int entityID;
    private CompoundTag tag;

    public RVCapUpdatePacket(int id, CompoundTag tag) {
        this.entityID = id;
        this.tag = tag;
    }

    public RVCapUpdatePacket(LivingEntity living) {
        this.entityID = living.m_19879_();
        living.getCapability(RVCapProvider.CAPABILITY, null).ifPresent(misc -> {
            this.tag = RVCapHelper.save(new CompoundTag(), misc);
        });
    }

    public static void encode(RVCapUpdatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityID);
        buffer.m_130079_(packet.tag);
    }

    public static RVCapUpdatePacket decode(FriendlyByteBuf buffer) {
        return new RVCapUpdatePacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void consume(RVCapUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel clientLevel;
            Entity entity;
            Level level;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = RoyalVariations.PROXY.getLevel()) instanceof ClientLevel && (entity = (clientLevel = (ClientLevel)level).m_6815_(packet.entityID)) != null) {
                entity.getCapability(RVCapProvider.CAPABILITY).ifPresent(misc -> RVCapHelper.load(packet.tag, misc));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

