/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mongoose.royalvariations.client.render.model.GloveModel;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public record WearRenderer(ResourceLocation texture, HumanoidModel<LivingEntity> model) implements ICurioRenderer
{
    private ResourceLocation getTexture(LivingEntity livingEntity) {
        return this.texture;
    }

    private HumanoidModel<LivingEntity> getModel() {
        return this.model;
    }

    @Nullable
    public static WearRenderer getRenderer(ItemStack stack) {
        if (!stack.m_41619_()) {
            return CuriosRendererRegistry.getRenderer((Item)stack.m_41720_()).orElse(null);
        }
        return null;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        HumanoidModel<LivingEntity> model = this.getModel();
        model.m_6973_(slotContext.entity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_6839_(slotContext.entity(), limbSwing, limbSwingAmount, partialTicks);
        ICurioRenderer.followBodyRotations((LivingEntity)slotContext.entity(), (HumanoidModel[])new HumanoidModel[]{model});
        this.render(livingEntity, matrixStack, renderTypeBuffer, light);
    }

    private void render(LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        RenderType renderType = this.getModel().m_103119_(this.getTexture(livingEntity));
        VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
        this.getModel().m_7695_(matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderFirstPersonArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side, boolean hasFoil) {
        if (!player.m_5833_()) {
            GloveModel model = (GloveModel)this.getModel();
            ModelPart arm = side == HumanoidArm.LEFT ? model.f_102812_ : model.f_102811_;
            model.m_8009_(false);
            arm.f_104207_ = true;
            model.f_102817_ = false;
            model.f_102608_ = 0.0f;
            model.f_102818_ = 0.0f;
            model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.f_104203_ = 0.0f;
            this.renderFirstPersonArm((LivingEntity)player, model, arm, matrixStack, buffer, light, hasFoil);
        }
    }

    private void renderFirstPersonArm(LivingEntity livingEntity, GloveModel model, ModelPart arm, PoseStack matrixStack, MultiBufferSource buffer, int light, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(livingEntity));
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        arm.m_104301_(matrixStack, builder, light, OverlayTexture.f_118083_);
    }
}

