/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class RoyalGlowParticleOption
implements ParticleOptions {
    public static final Codec<RoyalGlowParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.INT.fieldOf("speed").forGetter(d -> d.speed)).apply((Applicative)instance, RoyalGlowParticleOption::new));
    public static final ParticleOptions.Deserializer<RoyalGlowParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<RoyalGlowParticleOption>(){

        public RoyalGlowParticleOption fromCommand(ParticleType<RoyalGlowParticleOption> p_235961_, StringReader p_235962_) throws CommandSyntaxException {
            p_235962_.expect(' ');
            float r = p_235962_.readFloat();
            p_235962_.expect(' ');
            float g = p_235962_.readFloat();
            p_235962_.expect(' ');
            float b = p_235962_.readFloat();
            p_235962_.expect(' ');
            float s = p_235962_.readFloat();
            p_235962_.expect(' ');
            int s2 = p_235962_.readInt();
            return new RoyalGlowParticleOption(r, g, b, s, s2);
        }

        public RoyalGlowParticleOption fromNetwork(ParticleType<RoyalGlowParticleOption> p_235964_, FriendlyByteBuf p_235965_) {
            return new RoyalGlowParticleOption(p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readInt());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float size;
    private final int speed;

    public RoyalGlowParticleOption(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.size = 10.0f;
        this.speed = 0;
    }

    public RoyalGlowParticleOption(float r, float g, float b, float size, int speed) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.size = size;
        this.speed = speed;
    }

    public void m_7711_(FriendlyByteBuf p_235956_) {
        p_235956_.writeFloat(this.red);
        p_235956_.writeFloat(this.green);
        p_235956_.writeFloat(this.blue);
        p_235956_.writeFloat(this.size);
        p_235956_.writeInt(this.speed);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.size), this.speed);
    }

    public ParticleType<RoyalGlowParticleOption> m_6012_() {
        return (ParticleType)RVParticleTypes.ROYAL_GLOW.get();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getSize() {
        return this.size;
    }

    public int getSpeed() {
        return this.speed;
    }
}

