/*
 * Decompiled with CFR 0.152.
 */
package com.mongoose.royalvariations;

import com.mojang.logging.LogUtils;
import com.mongoose.royalvariations.client.ClientProxy;
import com.mongoose.royalvariations.client.particles.RVParticleTypes;
import com.mongoose.royalvariations.common.CommonProxy;
import com.mongoose.royalvariations.common.effects.RVEffects;
import com.mongoose.royalvariations.common.entities.RVEntityType;
import com.mongoose.royalvariations.common.entities.hostile.RoyalCreeper;
import com.mongoose.royalvariations.common.entities.hostile.RoyalSkeleton;
import com.mongoose.royalvariations.common.entities.hostile.RoyalZombie;
import com.mongoose.royalvariations.common.entities.neutral.RoyalEnderman;
import com.mongoose.royalvariations.common.items.RVItems;
import com.mongoose.royalvariations.common.network.RVNetwork;
import com.mongoose.royalvariations.common.world.RVMobSpawnBiomeModifier;
import com.mongoose.royalvariations.compat.OtherModCompat;
import com.mongoose.royalvariations.config.RVConfig;
import com.mongoose.royalvariations.init.ClientSideInit;
import com.mongoose.royalvariations.init.RVCreativeTab;
import com.mongoose.royalvariations.init.RVProxy;
import com.mongoose.royalvariations.init.RVSounds;
import com.mongoose.royalvariations.init.SidedInit;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="royalvariations")
public class RoyalVariations {
    public static final String MOD_ID = "royalvariations";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static RVProxy PROXY = (RVProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static SidedInit SIDED_INIT = (SidedInit)DistExecutor.unsafeRunForDist(() -> ClientSideInit::new, () -> SidedInit::new);

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public RoyalVariations() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RVEntityType.ENTITY_TYPE.register(modEventBus);
        RVParticleTypes.PARTICLE_TYPES.register(modEventBus);
        RVCreativeTab.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupEntityAttributeCreation);
        modEventBus.addListener(this::SpawnPlacementEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RVConfig.SPEC, "royalvariations.toml");
        RVConfig.loadConfig(RVConfig.SPEC, FMLPaths.CONFIGDIR.get().resolve("royalvariations.toml").toString());
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("mob_spawns", RVMobSpawnBiomeModifier::makeCodec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RVItems.init();
        RVEffects.init();
        RVSounds.init();
        SIDED_INIT.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RVNetwork.init();
        OtherModCompat.setup(event);
    }

    private void setupEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)RVEntityType.ROYAL_BOMB.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)RVEntityType.ROYAL_ZOMBIE.get(), RoyalZombie.createAttributes().m_22265_());
        event.put((EntityType)RVEntityType.ROYAL_SKELETON.get(), RoyalSkeleton.createAttributes().m_22265_());
        event.put((EntityType)RVEntityType.ROYAL_CREEPER.get(), RoyalCreeper.createAttributes().m_22265_());
        event.put((EntityType)RVEntityType.ROYAL_ENDERMAN.get(), RoyalEnderman.createAttributes().m_22265_());
    }

    private void SpawnPlacementEvent(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)RVEntityType.ROYAL_ZOMBIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)RVEntityType.ROYAL_SKELETON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)RVEntityType.ROYAL_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)RVEntityType.ROYAL_ENDERMAN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HANDS.getMessageBuilder().build());
    }
}

